/*
 * Decompiled with CFR 0.152.
 */
package ispitivaci;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispitivaci.BazaIspitivac;
import ispitivaci.Ispitivac;
import ispitivaci.UnosIspitivacaController;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import zastitanaradu.GlavniPanelController;

public class PopisIspitivacaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Ispitivac> tablicaPopisIspitivaca;
    @FXML
    private TableColumn<Ispitivac, String> kolPretraga;
    @FXML
    private TableColumn<Ispitivac, String> kolRedBr;
    @FXML
    private TableColumn<Ispitivac, String> kolIme;
    @FXML
    private TableColumn<Ispitivac, String> kolOvla\u0161tenaTvrtka;
    @FXML
    private TableColumn<Ispitivac, String> kolStrucnaSprema;
    @FXML
    private TableColumn<Ispitivac, String> kolFunkcija;
    private static PopisIspitivacaController instance;
    private final ObservableList<Ispitivac> listaIspitivaca = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisIspitivacaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciIspitivaci();
        this.popuniTablicuIspitivaci();
        this.urediFilter(this.tablicaPopisIspitivaca);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Ispitivaca")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Ispitivaca");
                GlavniPanelController.getInstance().nadodajPanel("Unos Ispitivaca", "/ispitivaci/UnosIspitivaca.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Ispitivaca", "/ispitivaci/UnosIspitivaca.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Ispitivac is;
            int selectdIndex = this.tablicaPopisIspitivaca.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (is = (Ispitivac)this.tablicaPopisIspitivaca.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Ispitivaca")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Ispitivaca");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Ispitivaca", "/ispitivaci/UnosIspitivaca.fxml");
                    UnosIspitivacaController.getInstance().izmjenaHzzo(is);
                    this.tablicaPopisIspitivaca.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Ispitivaca", "/ispitivaci/UnosIspitivaca.fxml");
                    UnosIspitivacaController.getInstance().izmjenaHzzo(is);
                    this.tablicaPopisIspitivaca.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisIspitivaca.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati ispitivs\u010da")).showAndWait()).get() == ButtonType.OK) {
                if (BazaIspitivac.obrisiIspitivaca((Ispitivac)this.tablicaPopisIspitivaca.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuIspitivaci();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan ispitiva\u010d", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan ispitiva\u010d", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Ime i prezime", "Ovla\u0161tena tvrtka", "Funkcija"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Ime i prezime");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaIspitivaca, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Ime i prezime") ? pregled.getIme() != null && pregled.getIme().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Ovla\u0161tena tvrtka") ? pregled.getOvlastenaTvrtka() != null && pregled.getOvlastenaTvrtka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Funkcija") && pregled.getFunkcija() != null && pregled.getFunkcija().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciIspitivaci() {
        this.tablicaPopisIspitivaca.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisIspitivacaController.this.tablicaPopisIspitivaca.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((Ispitivac)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivaca.widthProperty().divide(11.11111111111111));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setCellValueFactory(cell -> ((Ispitivac)cell.getValue()).imeProperty());
        this.kolIme.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivaca.widthProperty().divide(5.0));
        this.kolIme.setStyle("-fx-alignment: CENTER;");
        this.kolOvla\u0161tenaTvrtka.setCellValueFactory(cell -> ((Ispitivac)cell.getValue()).ovlastenaTvrtkaProperty());
        this.kolOvla\u0161tenaTvrtka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivaca.widthProperty().divide(4.0));
        this.kolOvla\u0161tenaTvrtka.setStyle("-fx-alignment: CENTER;");
        this.kolStrucnaSprema.setCellValueFactory(cell -> ((Ispitivac)cell.getValue()).strucnaSpremaProperty());
        this.kolStrucnaSprema.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivaca.widthProperty().divide(10.0));
        this.kolStrucnaSprema.setStyle("-fx-alignment: CENTER;");
        this.kolFunkcija.setCellValueFactory(cell -> ((Ispitivac)cell.getValue()).funkcijaProperty());
        this.kolFunkcija.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivaca.widthProperty().divide(6.666666666666667));
        this.kolFunkcija.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuIspitivaci() {
        this.tablicaPopisIspitivaca.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaIspitivaca.clear();
        this.tablicaPopisIspitivaca.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisIspitivacaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisIspitivacaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisIspitivacaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaIspitivac.dajIspitivace(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Ispitivac is = new Ispitivac();
                is.setId(rs.getInt("id"));
                is.setRedBroj(String.valueOf(br));
                is.setIme(rs.getString("ime"));
                is.setOib(rs.getString("oib"));
                is.setOvlastenaTvrtka(rs.getString("ovlastenatvrtka"));
                is.setStrucnaSprema(rs.getString("strucnasprema"));
                is.setFunkcija(rs.getString("funkcijauorganizaciji"));
                is.setEmail(rs.getString("email"));
                is.setTelefon(rs.getString("telefon"));
                this.listaIspitivaca.add((Object)is);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisIspitivacaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisIspitivacaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisIspitivaca.getItems().addAll(this.listaIspitivaca);
    }
}

