/*
 * Decompiled with CFR 0.152.
 */
package ispisJasper;

import ispisJasper.ZoomableScrollPane;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleDocxReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;

public class JasperViewerFX {
    private final Stage dialog;
    private Button print;
    private Button save;
    private Button backPage;
    private Button firstPage;
    private Button nextPage;
    private Button lastPage;
    private Button zoomIn;
    private Button zoomOut;
    private Label bottomLabel;
    private ImageView report;
    private TextField txtPage;
    private ZoomableScrollPane scroll;
    protected DropShadow dropShadow = new DropShadow();
    public static final int REPORT_DPI_RESOLUTION = 72;
    protected double screenResolution = 72.0;
    private JasperReport jreport;
    private JasperPrint jprint;
    private int imageHeight = 0;
    private int imageWidth = 0;
    private int reportPages = 0;
    private IntegerProperty currentPage;
    private String title;

    public JasperViewerFX(Stage owner, String title, JasperPrint jasperPrint) {
        this.title = title;
        this.dialog = new Stage();
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.initOwner((Window)owner);
        this.dialog.setScene(this.createScene());
        this.dialog.setTitle(title);
        this.dialog.getIcons().add((Object)new Image("/resorces/icon/printer.png"));
        this.jprint = jasperPrint;
        this.imageHeight = this.jprint.getPageHeight() + 284;
        this.imageWidth = this.jprint.getPageWidth() + 201;
        this.reportPages = this.jprint.getPages().size();
        this.screenResolution = Screen.getPrimary().getDpi();
    }

    public JasperViewerFX(Stage owner, String title, String jasper, HashMap params, Connection con) {
        this.title = title;
        this.dialog = new Stage();
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.initOwner((Window)owner);
        this.dialog.setScene(this.createScene());
        this.dialog.setTitle(title);
        this.dialog.getIcons().add((Object)new Image("/resorces/icon/printer.png"));
        try {
            URL url = this.getClass().getResource(jasper);
            this.jreport = (JasperReport)JRLoader.loadObject((URL)url);
            this.jprint = JasperFillManager.fillReport((JasperReport)this.jreport, (Map)params, (Connection)con);
            this.imageHeight = this.jprint.getPageHeight() + 284;
            this.imageWidth = this.jprint.getPageWidth() + 201;
            this.reportPages = this.jprint.getPages().size();
        }
        catch (JRException jRException) {
            // empty catch block
        }
    }

    public JasperViewerFX(Stage owner, String title, String jasper, HashMap params, JRBeanCollectionDataSource source) {
        this.title = title;
        this.dialog = new Stage();
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.initOwner((Window)owner);
        this.dialog.setScene(this.createScene());
        this.dialog.setTitle(title);
        this.dialog.getIcons().add((Object)new Image("/resorces/icon/printer.png"));
        try {
            URL arquivo = this.getClass().getResource(jasper);
            this.jreport = (JasperReport)JRLoader.loadObject((URL)arquivo);
            this.jprint = JasperFillManager.fillReport((JasperReport)this.jreport, (Map)params, (JRDataSource)source);
            this.imageHeight = this.jprint.getPageHeight() + 284;
            this.imageWidth = this.jprint.getPageWidth() + 201;
            this.reportPages = this.jprint.getPages().size();
        }
        catch (JRException jRException) {
            // empty catch block
        }
    }

    public void setCurrentPage(int page) {
        this.currentPage.set(page);
        this.viewPage(page);
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    private Scene createScene() {
        HBox menu = new HBox(5.0);
        menu.setAlignment(Pos.CENTER);
        menu.setPrefHeight(50.0);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", Locale.getDefault());
        this.print = new Button(null, (Node)new ImageView("/resorces/icon/printer.png"));
        this.print.setTooltip(new Tooltip(resourceBundle.getString("print")));
        this.save = new Button(null, (Node)new ImageView("/resorces/icon/save.png"));
        this.save.setTooltip(new Tooltip(resourceBundle.getString("save")));
        this.backPage = new Button(null, (Node)new ImageView(new Image(this.getClass().getResourceAsStream("/net/sf/jasperreports/view/images/previous.GIF"))));
        this.backPage.setTooltip(new Tooltip(resourceBundle.getString("previous.page")));
        this.firstPage = new Button(null, (Node)new ImageView(new Image(this.getClass().getResourceAsStream("/net/sf/jasperreports/view/images/first.GIF"))));
        this.firstPage.setTooltip(new Tooltip(resourceBundle.getString("first.page")));
        this.nextPage = new Button(null, (Node)new ImageView(new Image(this.getClass().getResourceAsStream("/net/sf/jasperreports/view/images/next.GIF"))));
        this.nextPage.setTooltip(new Tooltip(resourceBundle.getString("next.page")));
        this.lastPage = new Button(null, (Node)new ImageView(new Image(this.getClass().getResourceAsStream("/net/sf/jasperreports/view/images/last.GIF"))));
        this.lastPage.setTooltip(new Tooltip(resourceBundle.getString("last.page")));
        this.zoomIn = new Button(null, (Node)new ImageView("/resorces/icon/zoomin.png"));
        this.zoomIn.setTooltip(new Tooltip(resourceBundle.getString("zoom.in")));
        this.zoomOut = new Button(null, (Node)new ImageView("/resorces/icon/zoomout.png"));
        this.zoomOut.setTooltip(new Tooltip(resourceBundle.getString("zoom.out")));
        this.print.setPrefSize(30.0, 30.0);
        this.save.setPrefSize(30.0, 30.0);
        this.backPage.setPrefSize(30.0, 30.0);
        this.firstPage.setPrefSize(30.0, 30.0);
        this.nextPage.setPrefSize(30.0, 30.0);
        this.lastPage.setPrefSize(30.0, 30.0);
        this.zoomIn.setPrefSize(30.0, 30.0);
        this.zoomOut.setPrefSize(30.0, 30.0);
        this.txtPage = new TextField("1");
        this.txtPage.setAlignment(Pos.CENTER);
        this.txtPage.setPrefSize(50.0, 23.0);
        menu.getChildren().addAll((Object[])new Node[]{this.print, this.save, this.firstPage, this.backPage, this.txtPage, this.nextPage, this.lastPage, this.zoomIn, this.zoomOut});
        this.report = new ImageView();
        this.report.setFitHeight((double)this.imageHeight);
        this.report.setFitWidth((double)this.imageWidth);
        Group contentGroup = new Group();
        contentGroup.getChildren().add((Object)this.report);
        StackPane stack = new StackPane(new Node[]{contentGroup});
        stack.setAlignment(Pos.CENTER);
        this.scroll = new ZoomableScrollPane((Node)stack);
        this.bottomLabel = new Label();
        HBox statusBar = new HBox();
        this.bottomLabel.setStyle(" -fx-font-weight: bold;-fx-font-size:12px;");
        statusBar.setAlignment(Pos.CENTER);
        statusBar.setMaxHeight(24.0);
        statusBar.getChildren().add((Object)this.bottomLabel);
        BorderPane root = new BorderPane();
        root.setCenter((Node)this.scroll);
        root.setTop((Node)menu);
        root.setBottom((Node)statusBar);
        this.dropShadow.setColor(Color.GREY);
        this.dropShadow.setOffsetX(2.0);
        this.dropShadow.setOffsetY(2.0);
        this.report.setEffect((Effect)this.dropShadow);
        Scene scene = new Scene((Parent)root, 1024.0, 768.0);
        return scene;
    }

    private void start() {
        this.currentPage = new SimpleIntegerProperty((Object)this, "currentPage");
        this.setCurrentPage(1);
        this.bottomLabel.setText("Stranica 1 od " + this.reportPages);
        this.currentPage.addListener((observable, oldValue, newValue) -> {
            this.bottomLabel.setText("Stranica " + newValue + " od " + this.reportPages);
            this.txtPage.setText(newValue.toString());
            if (newValue.intValue() == 1) {
                this.backPage.setDisable(true);
                this.firstPage.setDisable(true);
            }
            if (newValue.intValue() == this.reportPages) {
                this.nextPage.setDisable(true);
                this.lastPage.setDisable(true);
            }
        });
        this.backPage.setDisable(true);
        this.firstPage.setDisable(true);
        if (this.reportPages == 1) {
            this.nextPage.setDisable(true);
            this.lastPage.setDisable(true);
        }
        this.backPage.setOnAction(event -> this.backAction());
        this.firstPage.setOnAction(event -> this.firstPageAction());
        this.nextPage.setOnAction(event -> this.nextAction());
        this.lastPage.setOnAction(event -> this.lastPageAction());
        this.print.setOnAction(event -> this.printAction());
        this.save.setOnAction(event -> this.saveAction());
        this.zoomIn.setOnAction(event -> this.zoomInAction());
        this.zoomOut.setOnAction(event -> this.zoomOutAction());
        this.txtPage.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                try {
                    int p = Integer.parseInt(this.txtPage.getText());
                    if (p > this.reportPages) {
                        this.setCurrentPage(this.reportPages);
                    } else if (p > 0) {
                        this.setCurrentPage(p);
                    } else {
                        this.setCurrentPage(1);
                    }
                }
                catch (NumberFormatException e) {
                    Alert dialog1 = new Alert(Alert.AlertType.WARNING, "Invalid number", new ButtonType[]{ButtonType.OK});
                    dialog1.show();
                }
            }
        });
    }

    private void backAction() {
        int newValue = this.getCurrentPage() - 1;
        this.setCurrentPage(newValue);
        if (this.nextPage.isDisabled()) {
            this.nextPage.setDisable(false);
            this.lastPage.setDisable(false);
        }
    }

    private void firstPageAction() {
        this.setCurrentPage(1);
        if (this.nextPage.isDisabled()) {
            this.nextPage.setDisable(false);
            this.lastPage.setDisable(false);
        }
    }

    private void nextAction() {
        int newValue = this.getCurrentPage() + 1;
        this.setCurrentPage(newValue);
        if (this.backPage.isDisabled()) {
            this.backPage.setDisable(false);
            this.firstPage.setDisable(false);
        }
    }

    private void lastPageAction() {
        this.setCurrentPage(this.reportPages);
        if (this.backPage.isDisabled()) {
            this.backPage.setDisable(false);
            this.firstPage.setDisable(false);
        }
    }

    private void printAction() {
        try {
            JasperPrintManager.printReport((JasperPrint)this.jprint, (boolean)true);
        }
        catch (JRException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void saveAction() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Save as");
        chooser.setInitialDirectory(new File(System.getProperty("user.dir")));
        chooser.setInitialFileName(this.title);
        FileChooser.ExtensionFilter pdf = new FileChooser.ExtensionFilter("Portable Document Format (*.pdf)", new String[]{"*.pdf"});
        FileChooser.ExtensionFilter html = new FileChooser.ExtensionFilter("HyperText Markup Language", new String[]{"*.html"});
        FileChooser.ExtensionFilter xml = new FileChooser.ExtensionFilter("eXtensible Markup Language", new String[]{"*.xml"});
        FileChooser.ExtensionFilter xls = new FileChooser.ExtensionFilter("Microsoft Excel 2007", new String[]{"*.xls"});
        FileChooser.ExtensionFilter xlsx = new FileChooser.ExtensionFilter("Microsoft Excel 2016", new String[]{"*.xlsx"});
        FileChooser.ExtensionFilter csv = new FileChooser.ExtensionFilter("Comma-separeted Values", new String[]{"*.csv"});
        FileChooser.ExtensionFilter docx = new FileChooser.ExtensionFilter("Microsoft Word", new String[]{"*.docx", "*.DOCX"});
        FileChooser.ExtensionFilter rtf = new FileChooser.ExtensionFilter("Microsoft Word", new String[]{"*.rtf", "*.RTF"});
        FileChooser.ExtensionFilter pptx = new FileChooser.ExtensionFilter("Microsoft Power Point", new String[]{"*.pptx", "*.pptx"});
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{pdf, html, xml, xls, xlsx, csv, docx, rtf, pptx});
        chooser.setSelectedExtensionFilter(pdf);
        File file = chooser.showSaveDialog((Window)this.dialog);
        if (file != null) {
            List box = chooser.getSelectedExtensionFilter().getExtensions();
            switch ((String)box.get(0)) {
                case "*.pdf": {
                    try {
                        JasperExportManager.exportReportToPdfFile((JasperPrint)this.jprint, (String)file.getPath());
                    }
                    catch (JRException jRException) {}
                    break;
                }
                case "*.html": {
                    try {
                        JasperExportManager.exportReportToHtmlFile((JasperPrint)this.jprint, (String)file.getPath());
                    }
                    catch (JRException jRException) {}
                    break;
                }
                case "*.xml": {
                    try {
                        JasperExportManager.exportReportToXmlFile((JasperPrint)this.jprint, (String)file.getPath(), (boolean)false);
                    }
                    catch (JRException jRException) {}
                    break;
                }
                case "*.xls": {
                    try {
                        JRXlsExporter exporter = new JRXlsExporter();
                        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jprint));
                        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
                        exporter.exportReport();
                    }
                    catch (JRException exporter) {}
                    break;
                }
                case "*.xlsx": {
                    try {
                        JRXlsxExporter exporter = new JRXlsxExporter();
                        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jprint));
                        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
                        exporter.exportReport();
                    }
                    catch (JRException exporter) {}
                    break;
                }
                case "*.csv": {
                    try {
                        JRCsvExporter exporter = new JRCsvExporter();
                        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jprint));
                        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(file));
                        exporter.exportReport();
                    }
                    catch (JRException exporter) {}
                    break;
                }
                case "*.docx": {
                    JRDocxExporter export = new JRDocxExporter();
                    export.setExporterInput((ExporterInput)new SimpleExporterInput(this.jprint));
                    export.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file.getAbsolutePath()));
                    SimpleDocxReportConfiguration config = new SimpleDocxReportConfiguration();
                    export.setConfiguration((ReportExportConfiguration)config);
                    try {
                        export.exportReport();
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "*.rtf": {
                    JRRtfExporter rtfExporter = new JRRtfExporter();
                    rtfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jprint));
                    rtfExporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(file.getAbsolutePath()));
                    try {
                        rtfExporter.exportReport();
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "*.pptx": {
                    try {
                        JRPptxExporter exporter = new JRPptxExporter();
                        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jprint));
                        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
                        exporter.exportReport();
                        break;
                    }
                    catch (JRException jRException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void show() {
        if (this.reportPages > 0) {
            this.start();
            this.dialog.show();
        } else {
            Alert dialog = new Alert(Alert.AlertType.INFORMATION, "Prazan izvje\u0161taj", new ButtonType[]{ButtonType.CLOSE});
            dialog.setHeaderText("Poruka");
            dialog.show();
        }
    }

    private void viewPage(int page) {
        try {
            float zoom = 2.0f;
            BufferedImage image = (BufferedImage)JasperPrintManager.printPageToImage((JasperPrint)this.jprint, (int)(page - 1), (float)zoom);
            WritableImage fxImage = new WritableImage(this.imageHeight, this.imageWidth);
            this.report.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)image, (WritableImage)fxImage));
        }
        catch (JRException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void zoomInAction() {
        this.report.setScaleX(this.report.getScaleX() + 0.15);
        this.report.setScaleY(this.report.getScaleY() + 0.15);
        this.report.setFitHeight((double)this.imageHeight + 0.15);
        this.report.setFitWidth((double)this.imageWidth + 0.15);
    }

    private void zoomOutAction() {
        this.report.setScaleX(this.report.getScaleX() - 0.15);
        this.report.setScaleY(this.report.getScaleY() - 0.15);
        this.report.setFitHeight((double)this.imageHeight - 0.15);
        this.report.setFitWidth((double)this.imageWidth - 0.15);
    }

    public void addMouseScrolling(Node node) {
        node.setOnScroll(event -> {
            node.setCursor(Cursor.OPEN_HAND);
            double minScale = 0.25;
            double maxScale = 5.0;
            if (event.isControlDown()) {
                double actualScale = node.getScaleX();
                if (actualScale > maxScale || actualScale < minScale) {
                    event.consume();
                    return;
                }
                double hVal = this.scroll.getHvalue();
                double vVal = this.scroll.getVvalue();
                double factor = event.getDeltaY() > 0.0 ? 1.1 : 0.9;
                double scale = actualScale * factor;
                scale = Math.min(scale, maxScale);
                scale = Math.max(scale, minScale);
                node.setScaleX(scale);
                node.setScaleY(scale);
                this.scroll.setHvalue(hVal);
                this.scroll.setVvalue(vVal);
                event.consume();
            }
        });
        SimpleObjectProperty lastMouseCoordinates = new SimpleObjectProperty();
        node.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>((ObjectProperty)lastMouseCoordinates, node){
            final /* synthetic */ ObjectProperty val$lastMouseCoordinates;
            final /* synthetic */ Node val$node;
            {
                this.val$lastMouseCoordinates = objectProperty;
                this.val$node = node;
            }

            public void handle(MouseEvent event) {
                this.val$lastMouseCoordinates.set((Object)new Point2D(event.getX(), event.getY()));
                this.val$node.setCursor(Cursor.CLOSED_HAND);
            }
        });
        node.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>((ObjectProperty)lastMouseCoordinates, node){
            final /* synthetic */ ObjectProperty val$lastMouseCoordinates;
            final /* synthetic */ Node val$node;
            {
                this.val$lastMouseCoordinates = objectProperty;
                this.val$node = node;
            }

            public void handle(MouseEvent event) {
                this.val$lastMouseCoordinates.set((Object)new Point2D(event.getX(), event.getY()));
                this.val$node.setCursor(Cursor.OPEN_HAND);
            }
        });
        node.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>((ObjectProperty)lastMouseCoordinates, node){
            final /* synthetic */ ObjectProperty val$lastMouseCoordinates;
            final /* synthetic */ Node val$node;
            {
                this.val$lastMouseCoordinates = objectProperty;
                this.val$node = node;
            }

            public void handle(MouseEvent event) {
                double deltaX = event.getX() - ((Point2D)this.val$lastMouseCoordinates.get()).getX();
                double extraWidth = this.val$node.getLayoutBounds().getWidth() - JasperViewerFX.this.scroll.getViewportBounds().getWidth();
                double deltaH = deltaX * (JasperViewerFX.this.scroll.getHmax() - JasperViewerFX.this.scroll.getHmin()) / extraWidth;
                double desiredH = JasperViewerFX.this.scroll.getHvalue() - deltaH;
                JasperViewerFX.this.scroll.setHvalue(Math.max(0.0, Math.min(JasperViewerFX.this.scroll.getHmax(), desiredH)));
                double deltaY = event.getY() - ((Point2D)this.val$lastMouseCoordinates.get()).getY();
                double extraHeight = this.val$node.getLayoutBounds().getHeight() - JasperViewerFX.this.scroll.getViewportBounds().getHeight();
                double deltaV = deltaY * (JasperViewerFX.this.scroll.getHmax() - JasperViewerFX.this.scroll.getHmin()) / extraHeight;
                double desiredV = JasperViewerFX.this.scroll.getVvalue() - deltaV;
                JasperViewerFX.this.scroll.setVvalue(Math.max(0.0, Math.min(JasperViewerFX.this.scroll.getVmax(), desiredV)));
            }
        });
    }
}

