/*
 * Decompiled with CFR 0.152.
 */
package hzzo;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import hzzo.BazaHzzo;
import hzzo.Hzzo;
import hzzo.UnosHzzoIspostavaController;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zastitanaradu.GlavniPanelController;

public class PopisHzzoController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Hzzo> tablicaPopisHzzo;
    @FXML
    private TableColumn<Hzzo, String> kolPretraga;
    @FXML
    private TableColumn<Hzzo, String> kolRedBr;
    @FXML
    private TableColumn<Hzzo, String> kolNaziv;
    @FXML
    private TableColumn<Hzzo, String> kolAdresa;
    @FXML
    private TableColumn<Hzzo, String> kolMjesto;
    private static PopisHzzoController instance;
    private final ObservableList<Hzzo> listaHzzo = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisHzzoController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciHzzo();
        this.popuniTablicuHzzo();
        this.urediFilter(this.tablicaPopisHzzo);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Hzzo")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Hzzo");
                GlavniPanelController.getInstance().nadodajPanel("Unos Hzzo", "/hzzo/UnosHzzoIspostava.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Hzzo", "/hzzo/UnosHzzoIspostava.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Hzzo hz;
            int selectdIndex = this.tablicaPopisHzzo.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (hz = (Hzzo)this.tablicaPopisHzzo.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Hzzo")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Hzzo");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Hzzo", "/hzzo/UnosHzzoIspostava.fxml");
                    UnosHzzoIspostavaController.getInstance().izmjenaHzzo(hz);
                    this.tablicaPopisHzzo.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Hzzo", "/hzzo/UnosHzzoIspostava.fxml");
                    UnosHzzoIspostavaController.getInstance().izmjenaHzzo(hz);
                    this.tablicaPopisHzzo.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisHzzo.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati hzzo ispostavu")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraHzzo((Hzzo)this.tablicaPopisHzzo.getSelectionModel().getSelectedItem())) {
                if (BazaHzzo.obrisiHzzo((Hzzo)this.tablicaPopisHzzo.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuHzzo();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana hzzop ispostava", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana hhzo ispostava", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Mjesto", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaHzzo, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Mjesto") ? pregled.getMjesto() != null && pregled.getMjesto().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciHzzo() {
        this.tablicaPopisHzzo.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisHzzoController.this.tablicaPopisHzzo.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisHzzo.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cell -> ((Hzzo)cell.getValue()).nazivProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisHzzo.widthProperty().divide(2.0408163265306123));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolAdresa.setCellValueFactory(cell -> ((Hzzo)cell.getValue()).adresaProperty());
        this.kolAdresa.prefWidthProperty().bind((ObservableValue)this.tablicaPopisHzzo.widthProperty().divide(5.0));
        this.kolAdresa.setStyle("-fx-alignment: CENTER;");
        this.kolMjesto.setCellValueFactory(cell -> ((Hzzo)cell.getValue()).mjestoProperty());
        this.kolMjesto.prefWidthProperty().bind((ObservableValue)this.tablicaPopisHzzo.widthProperty().divide(5.0));
        this.kolMjesto.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuHzzo() {
        this.tablicaPopisHzzo.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaHzzo.clear();
        this.tablicaPopisHzzo.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisHzzoController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisHzzoController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisHzzoController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaHzzo.dajHzzo(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Hzzo hz = new Hzzo();
                hz.setId(rs.getInt("id"));
                hz.setRedBroj(String.valueOf(br));
                hz.setNaziv(rs.getString("naziv"));
                hz.setSifra(rs.getString("sifra"));
                hz.setAdresa(rs.getString("adresa"));
                hz.setMjesto(rs.getString("mjesto"));
                hz.setTelefon(rs.getString("telefon"));
                hz.setFax(rs.getString("fax"));
                this.listaHzzo.add((Object)hz);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisHzzoController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisHzzoController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisHzzo.getItems().addAll(this.listaHzzo);
    }
}

