/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ComboBoxUtill;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.JasperViewerFX;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JasperPrint;
import odjeli.Odjel;
import poslovnejedinice.PoslovneJedinice;
import pregledivatrogasniaparati.PregledVA;
import vatrogasniaparati.VrstaVatrogasnihAparata;
import zastitanaradu.GlavniPanelController;

public class FilterVatrogasniAparatiController
implements Initializable {
    @FXML
    private ComboBox<PoslovneJedinice> cboxPoslovnaJedinica;
    @FXML
    private ComboBox<Odjel> cboxOdjel;
    @FXML
    private ComboBox<PregledVA> cboxNazivPregleda;
    @FXML
    private ComboBox<VrstaVatrogasnihAparata> cboxVrstaAparata;
    @FXML
    private DatePicker dateIspitivanjaOD;
    @FXML
    private DatePicker dateIspitivanjaDO;
    @FXML
    private DatePicker dateIstjeceOD;
    @FXML
    private DatePicker dateIstjeceDO;
    @FXML
    private CheckBox chboxAparatiUVozilu;
    @FXML
    private CheckBox chboxOdjavljen;
    @FXML
    private ComboBox<String> cboxSortiraj;
    @FXML
    private Button btnIspis;

    public void initialize(URL url, ResourceBundle rb) {
        this.cboxPoslovnaJedinica = ComboBoxUtill.getCBoxPoslovnice(this.cboxPoslovnaJedinica);
        this.cboxOdjel = ComboBoxUtill.getCBoxOdjele(this.cboxOdjel);
        this.cboxNazivPregleda = ComboBoxUtill.getCBoxNazivPregleda(this.cboxNazivPregleda);
        this.cboxVrstaAparata = ComboBoxUtill.getCBoxVrstaAparata(this.cboxVrstaAparata);
        this.cboxSortiraj = ComboBoxUtill.getCBoxSortiraj((ObservableList<String>)FXCollections.observableArrayList((Object[])new String[]{"Poslovna jedinica", "Odjel", "Vrsta aparata", "Vrsta pregleda", "Datum obavljenog pregleda", "Datum ponovog pregleda"}), this.cboxSortiraj);
        ComboBoxUtill.makeDatePickerDelete(this.dateIstjeceDO, this.dateIstjeceOD, this.dateIspitivanjaDO, this.dateIspitivanjaOD);
        this.btnIspis.setOnAction(e -> this.ispis());
    }

    private void ispis() {
        String sql = " select * from vatrogasniaparatipopis where idtvrtka=" + GlavniPanelController.getOdabranaTvrtka().getId();
        StringBuilder sb = new StringBuilder(sql);
        if (!this.cboxPoslovnaJedinica.getSelectionModel().isEmpty()) {
            sb.append(" and idposlovnice=" + ((PoslovneJedinice)this.cboxPoslovnaJedinica.getValue()).getId());
        }
        if (!this.cboxOdjel.getSelectionModel().isEmpty()) {
            sb.append(" and idodjela=" + ((Odjel)this.cboxOdjel.getValue()).getId());
        }
        if (!this.cboxNazivPregleda.getSelectionModel().isEmpty()) {
            sb.append(" and pregled=" + ((PregledVA)this.cboxNazivPregleda.getValue()).getId());
        }
        if (!this.cboxVrstaAparata.getSelectionModel().isEmpty()) {
            sb.append(" and vrstaaparata=" + ((VrstaVatrogasnihAparata)this.cboxVrstaAparata.getValue()).getId());
        }
        if (this.dateIspitivanjaOD.getValue() != null & this.dateIspitivanjaDO.getValue() != null) {
            sb.append(" and datumpregleda  between '" + this.dateIspitivanjaOD.getValue() + "' and '" + this.dateIspitivanjaDO.getValue() + "'");
        }
        if (this.dateIstjeceOD.getValue() != null & this.dateIstjeceDO.getValue() != null) {
            sb.append(" and datumponovogpregleda  between '" + this.dateIstjeceOD.getValue() + "' and '" + this.dateIstjeceDO.getValue() + "'");
        }
        if (this.chboxOdjavljen.isSelected()) {
            sb.append(" and rashodovan=true");
        } else {
            sb.append(" and rashodovan=false");
        }
        if (this.chboxAparatiUVozilu.isSelected()) {
            sb.append(" and aparatuvozilu=true");
        }
        sb.append("  order by id");
        if (!this.cboxSortiraj.getSelectionModel().isEmpty()) {
            switch ((String)this.cboxSortiraj.getValue()) {
                case "Poslovna jedinica": {
                    sb.append(" , nazivposlovnice");
                    break;
                }
                case "Odjel": {
                    sb.append(" , nazivodjela");
                    break;
                }
                case "Vrsta aparata": {
                    sb.append(" , vrstaaparatanaziv");
                    break;
                }
                case "Vrsta pregleda": {
                    sb.append(" , nazivpregledava");
                    break;
                }
                case "Datum obavljenog pregleda": {
                    sb.append(" , datumpregleda");
                    break;
                }
                case "Datum ponovog pregleda": {
                    sb.append(" , datumponovogpregleda");
                    break;
                }
            }
        }
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sb.toString(), "IspisVatrogasniAparati.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }
}

