/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ComboBoxUtill;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.JasperViewerFX;
import ispitivanja.Ispitivanje;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JasperPrint;
import odjeli.Odjel;
import poslovnejedinice.PoslovneJedinice;
import zastitanaradu.GlavniPanelController;

public class FilterObjektiController
implements Initializable {
    @FXML
    private ComboBox<PoslovneJedinice> cboxPoslovnaJedinica;
    @FXML
    private ComboBox<Ispitivanje> cboxIspitivanje;
    @FXML
    private ComboBox<Odjel> cboxNaziv;
    @FXML
    private DatePicker dateIspitivanjaOD;
    @FXML
    private DatePicker dateIspitivanjaDO;
    @FXML
    private DatePicker dateIstjeceOD;
    @FXML
    private DatePicker dateIstjeceDO;
    @FXML
    private ComboBox<String> cboxSortiraj;
    @FXML
    private Button btnIspis;
    @FXML
    private CheckBox chBoxZatvoren;

    public void initialize(URL url, ResourceBundle rb) {
        this.cboxPoslovnaJedinica = ComboBoxUtill.getCBoxPoslovnice(this.cboxPoslovnaJedinica);
        this.cboxNaziv = ComboBoxUtill.getCBoxOdjele(this.cboxNaziv);
        this.cboxNaziv.setPromptText("Naziv objekta");
        this.cboxIspitivanje = ComboBoxUtill.getCBoxIspitivanja(this.cboxIspitivanje);
        this.cboxSortiraj = ComboBoxUtill.getCBoxSortiraj((ObservableList<String>)FXCollections.observableArrayList((Object[])new String[]{"Poslovna jedinica", "Naziv objekta", "Naziv ispitivanja", "Datum obavljenog ispitivanja", "Datum ponovog ispitivanja"}), this.cboxSortiraj);
        ComboBoxUtill.makeDatePickerDelete(this.dateIstjeceDO, this.dateIstjeceOD, this.dateIspitivanjaDO, this.dateIspitivanjaOD);
        this.btnIspis.setOnAction(e -> this.ispis());
    }

    private void ispis() {
        String sql = " select * from objektipopis where idtvrtka=" + GlavniPanelController.getOdabranaTvrtka().getId();
        StringBuilder sb = new StringBuilder(sql);
        if (!this.cboxPoslovnaJedinica.getSelectionModel().isEmpty()) {
            sb.append(" and idposlovnajedinica=" + ((PoslovneJedinice)this.cboxPoslovnaJedinica.getValue()).getId());
        }
        if (!this.cboxNaziv.getSelectionModel().isEmpty()) {
            sb.append(" and nazivobjekta=" + ((Odjel)this.cboxNaziv.getValue()).getId());
        }
        if (!this.cboxIspitivanje.getSelectionModel().isEmpty()) {
            sb.append(" and idispitivanja=" + ((Ispitivanje)this.cboxIspitivanje.getValue()).getId());
        }
        if (this.dateIspitivanjaOD.getValue() != null & this.dateIspitivanjaDO.getValue() != null) {
            sb.append(" and datumobavljenogispitivanja  between '" + this.dateIspitivanjaOD.getValue() + "' and '" + this.dateIspitivanjaDO.getValue() + "'");
        }
        if (this.dateIstjeceOD.getValue() != null & this.dateIstjeceDO.getValue() != null) {
            sb.append(" and datumponovogispitivanja  between '" + this.dateIstjeceOD.getValue() + "' and '" + this.dateIstjeceDO.getValue() + "'");
        }
        if (this.chBoxZatvoren.isSelected()) {
            sb.append(" and zatvoren=true");
        } else {
            sb.append(" and zatvoren=false");
        }
        sb.append(" order by objekatid");
        if (!this.cboxSortiraj.getSelectionModel().isEmpty()) {
            switch ((String)this.cboxSortiraj.getValue()) {
                case "Naziv ispitivanja": {
                    sb.append(" , nazivpregleda");
                    break;
                }
                case "Naziv objekta": {
                    sb.append(" , nazivodjela");
                    break;
                }
                case "Poslovna jedinica": {
                    sb.append(" , nazivposlovnice");
                    break;
                }
                case "Datum obavljenog ispitivanja": {
                    sb.append(" , datumobavljenogispitivanja");
                    break;
                }
                case "Datum ponovog ispitivanja": {
                    sb.append(" , datumponovogispitivanja");
                    break;
                }
            }
        }
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sb.toString(), "ObjektiIspis.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }
}

