/*
 * Decompiled with CFR 0.152.
 */
package dokumentiTvrtke;

import Utill.FxUtilTest;
import Utill.KlasaKorisneMetode;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class DokumentHiperlinkCell
extends TableCell<ScanDokument, String> {
    private ScanDokument sd = null;
    private File temp = null;
    private ComboBox<ScanDokument> comboBox;
    private ObservableList<ScanDokument> listaDokumentiCombo = FXCollections.observableArrayList();
    ProgressIndicator progressPane = new ProgressIndicator();
    Hyperlink h;
    BazaDokumenti bd;

    public DokumentHiperlinkCell(ObservableList<ScanDokument> listaDokumenti) {
        this.listaDokumentiCombo = listaDokumenti;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.setText(null);
            this.setGraphic((Node)this.getComboBox());
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(null);
        this.setGraphic((Node)this.getHiperLink(this.getString()));
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.getComboBox());
        } else {
            this.setText(null);
            if (this.getHiperLink(this.getString()) != null && !this.getString().equals("")) {
                this.setGraphic((Node)this.getHiperLink(this.getString()));
            } else {
                this.setGraphic(null);
            }
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(DokumentHiperlinkCell.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.prikaziDokument();
                    this.updateMessage("Running...");
                }
                finally {
                    Platform.runLater(() -> DokumentHiperlinkCell.this.setGraphic((Node)DokumentHiperlinkCell.this.h));
                }
                return null;
            }

            private void prikaziDokument() {
                try {
                    BazaDokumenti cfr_ignored_0 = DokumentHiperlinkCell.this.bd;
                    DokumentHiperlinkCell.this.writeToFileSystem(new ByteArrayInputStream(BazaDokumenti.getDokument(DokumentHiperlinkCell.this.h.getText())), DokumentHiperlinkCell.this.h.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(DokumentHiperlinkCell.class.getName()).log(Level.SEVERE, null, ex);
                }
                System.out.println("otvaram report na lokaciji " + DokumentHiperlinkCell.this.temp.getAbsolutePath());
                if (DokumentHiperlinkCell.this.temp.exists()) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(new File(DokumentHiperlinkCell.this.temp.getAbsolutePath()));
                            DokumentHiperlinkCell.this.getTableView().getSelectionModel().clearSelection();
                        }
                        catch (IOException eo) {
                            eo.printStackTrace();
                        }
                    } else {
                        System.out.println("Awt Desktop is not supported!");
                    }
                } else {
                    System.out.println("File is not exists!");
                }
            }
        };
    }

    private Hyperlink getHiperLink(String item) {
        this.h = new Hyperlink(item);
        this.bd = new BazaDokumenti();
        this.h.getStylesheets().add((Object)DokumentHiperlinkCell.class.getResource("dokumentitvrtke.css").toExternalForm());
        this.h.getStyleClass().add((Object)"myLink");
        this.h.disableProperty().bind((ObservableValue)this.getTableView().getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
        this.h.setOnAction(event -> {
            int selectdIndex = this.getTableView().getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.setGraphic((Node)this.progressPane);
                Task<Void> task = this.createTask();
                new Thread((Runnable)task).start();
                this.progressPane.progressProperty().bind((ObservableValue)task.progressProperty());
            }
        });
        return this.h;
    }

    private void writeToFileSystem(ByteArrayInputStream byteArrayInputStream, String nazivDokumenta) throws Exception {
        try {
            this.temp = File.createTempFile(nazivDokumenta, "." + KlasaKorisneMetode.getExtension(new File(nazivDokumenta)));
            this.temp.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fileOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteArray = new byte[byteArrayInputStream.available()];
        fileOutputStream = new FileOutputStream(this.temp);
        byteArrayOutputStream = new ByteArrayOutputStream(byteArrayInputStream.available());
        int x = byteArrayInputStream.read(byteArray, 0, byteArrayInputStream.available());
        byteArrayOutputStream.write(byteArray, 0, x);
        byteArrayOutputStream.writeTo(fileOutputStream);
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        fileOutputStream.close();
    }

    private ComboBox getComboBox() {
        this.comboBox = new ComboBox();
        this.comboBox.setPromptText("Odabareite dokument");
        this.comboBox.setItems(this.listaDokumentiCombo);
        FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getOpisDokumenta().toLowerCase().startsWith(typedText.toLowerCase()));
        FxUtilTest.getComboBoxValue(this.comboBox);
        this.comboBox.setConverter((StringConverter)new StringConverter<ScanDokument>(){

            public String toString(ScanDokument rm) {
                if (rm == null) {
                    return null;
                }
                return rm.getOpisDokumenta();
            }

            public ScanDokument fromString(String userId) {
                return null;
            }
        });
        this.comboBox.setCellFactory(p -> {
            ListCell<ScanDokument> cell = new ListCell<ScanDokument>(){

                protected void updateItem(ScanDokument t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    if (t != null) {
                        this.setText(t.getOpisDokumenta());
                    } else {
                        this.setText(null);
                    }
                }
            };
            return cell;
        });
        this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.comboBox.setOnAction(e -> {
            System.out.println("Committed: " + this.comboBox.getSelectionModel().getSelectedIndex());
            if (this.comboBox.getValue() != null) {
                this.sd = (ScanDokument)this.comboBox.getSelectionModel().getSelectedItem();
                this.commitEdit(((ScanDokument)this.comboBox.getValue()).getOpisDokumenta());
            } else {
                this.commitEdit(null);
            }
            System.out.println("string je " + this.getString());
        });
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.commitEdit(null);
            }
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            }
        });
        return this.comboBox;
    }
}

