/*
 * Decompiled with CFR 0.152.
 */
package csv;

import Utill.DateCell;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import poslovnejedinice.BazaPoslovneJedinice;
import poslovnejedinice.PoslovneJedinice;
import radnamjesta.BazaRadnaMjesta;
import radnamjesta.RadnoMjesto;
import zastitanaradu.GlavniPanelController;

public class UnosDjelatnikaCSVController
implements Initializable {
    @FXML
    private TableView<Djelatnik> tablicaDjelatnikCSV;
    @FXML
    private Button btnUnesiDJelatnikaCSV;
    @FXML
    private Button btnUnosUBazuPJ;
    @FXML
    private TableView<PoslovneJedinice> tablicaPoslovnaJedinicaCSV;
    @FXML
    private Button btnUnesiUtablicuPJ;
    @FXML
    private TextField txtBrojKolonePJ;
    @FXML
    private Button btnUnosRMUBazu;
    @FXML
    private Button btnUnesiUtablicuRM;
    @FXML
    private TextField txtBrojKoloneRM;
    @FXML
    private TableView<RadnoMjesto> tablicaRadnaMjestaCSV;
    @FXML
    private TextField txtPutanjaCSV;
    @FXML
    private Button btnPutanjaCSV;
    @FXML
    private Button btnUnosDjelatnikaUTablicu;
    private static UnosDjelatnikaCSVController instance;
    private static final String DATE_PATTERN = "d.M.yyyy";
    int lineNumber = 1;
    private static final DateTimeFormatter DATE_FORMATTER;
    File selectedFile = null;
    Collection<Djelatnik> listaDjelatnika = null;
    ObservableList<Djelatnik> listaDjelatnikaTablica = FXCollections.observableArrayList();
    ObservableList<PoslovneJedinice> listaPoslovneJedinice = FXCollections.observableArrayList();
    ObservableList<RadnoMjesto> listaRadnaMjesta = FXCollections.observableArrayList();
    Path myPath = null;
    List<String> lines = null;
    List<String> listposlovnajedinica = new ArrayList<String>();
    List<String> listradnomjesto = new ArrayList<String>();

    public static UnosDjelatnikaCSVController getInstance() {
        return instance;
    }

    public static LocalDate parse(String dateString) {
        try {
            return DATE_FORMATTER.parse((CharSequence)dateString, LocalDate::from);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.popuniKoloneUTAbliciPJ();
        this.popuniKoloneUTabliciRM();
        this.btnUnesiDJelatnikaCSV.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UnosDjelatnikaCSVController.this.unesiDjelatnikeUBazu();
            }
        }));
        this.btnUnosRMUBazu.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UnosDjelatnikaCSVController.this.unesiUBazu();
            }
        }));
        this.btnUnosUBazuPJ.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UnosDjelatnikaCSVController.this.unesiPJUBazu();
            }
        }));
        this.btnUnesiUtablicuRM.setOnAction(e -> {
            try {
                this.lines = Files.readAllLines(this.myPath, StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                Logger.getLogger(UnosDjelatnikaCSVController.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (String line : this.lines) {
                String[] array = line.split(";");
                this.listradnomjesto.add(array[6]);
            }
            RadnoMjesto rm = null;
            for (String s : this.listradnomjesto.parallelStream().skip(1L).distinct().collect(Collectors.toList())) {
                rm = new RadnoMjesto();
                rm.setNaziv(s);
                rm.setClanak("");
                rm.setOpasnostiRM("");
                rm.setTockePregleda("");
                rm.setPur("");
                this.listaRadnaMjesta.add((Object)rm);
            }
        });
        this.btnUnesiUtablicuPJ.setOnAction(e -> {
            try {
                this.lines = Files.readAllLines(this.myPath, StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                Logger.getLogger(UnosDjelatnikaCSVController.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (String line : this.lines) {
                String[] array = line.split(";");
                this.listposlovnajedinica.add(array[3]);
            }
            List list1 = this.listposlovnajedinica.stream().skip(1L).distinct().map(s -> s.split(" ")).filter(arr -> ((String[])arr).length == 2).map(arr -> new PoslovneJedinice(arr[0], arr[1])).collect(Collectors.toList());
            this.listaPoslovneJedinice.addAll(list1);
        });
        this.btnUnosDjelatnikaUTablicu.setOnAction(e -> this.unesiPodatkeuTablicuDjelatnikCSV());
        this.btnPutanjaCSV.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File selectedFile = fileChooser.showOpenDialog(null);
            if (selectedFile != null) {
                this.txtPutanjaCSV.setText(selectedFile.getAbsolutePath());
                this.myPath = Paths.get(this.txtPutanjaCSV.getText(), new String[0]);
            }
        });
    }

    private void unesiPodatkeuTablicuDjelatnikCSV() {
        this.popuniKoloneUTabliciDjelatnik();
        try {
            Files.readAllLines(this.myPath, StandardCharsets.UTF_8).stream().forEach(System.out::println);
            this.listaDjelatnika = Files.readAllLines(this.myPath, StandardCharsets.UTF_8).stream().skip(1L).map(line -> {
                Djelatnik d = new Djelatnik();
                String[] r = line.split(";");
                d.setRedBroj(String.valueOf(this.lineNumber));
                if (r.length == 42) {
                    d.setSifraDjelatnika(r[0]);
                    d.setIme(r[2]);
                    d.setPrezime(r[1]);
                    String[] s = r[3].split(" ");
                    d.setPoslovnaJedinica(s[1]);
                    d.setOdjel(s[1]);
                    d.setNazivRukovoditelja(r[5]);
                    d.setRadnoMjesto(r[6]);
                    d.setDatumZaposlenja(UnosDjelatnikaCSVController.parse(r[9]));
                    if (r[10].equals("neodre\u0111eno")) {
                        d.setVrstaZaposlenja("Ugovor na neodre\u0111eno");
                    } else {
                        d.setVrstaZaposlenja("Ugovor na odre\u0111eno");
                    }
                    d.setRadnoVrijeme(r[11]);
                    d.setStazIzvanTvrtke("0g 0m 0d");
                    if (r[17].equals("M")) {
                        d.setSpol("Mu\u0161ki");
                    } else {
                        d.setSpol("\u017denski");
                    }
                    d.setStrucnaSprema(r[18]);
                    d.setOIB(r[19]);
                    d.setStupanjObrazovanja(r[20] + " stupanj");
                    if (r[21] != null || !r[21].equals("")) {
                        d.setDatumRodjenja(UnosDjelatnikaCSVController.parse(r[21]));
                    }
                    d.setZanimianje(r[22]);
                    d.setMjestoRodjenja(r[23]);
                    d.setOpcinaRodjenja(r[24]);
                    switch (r[25]) {
                        case "RH": {
                            d.setDrzavaRodjenja("Hrvatska");
                            break;
                        }
                        case "BIH": {
                            d.setDrzavaRodjenja("Bosna i Hercegovina");
                            break;
                        }
                        case "RS": {
                            d.setDrzavaRodjenja("Srbija");
                            break;
                        }
                        default: {
                            d.setDrzavaRodjenja(r[25]);
                        }
                    }
                    d.setMjestoStanovanja(r[26]);
                    d.setAdresa(r[27]);
                    d.setImeOca(r[28]);
                    d.setImeMajke(r[29]);
                    d.setBrOsobneIskaznice(r[30]);
                    d.setBrOsiguraneOsobe(r[31]);
                    d.setKontaktTelefon(r[32]);
                    d.setNapomena(r[33]);
                    d.setVelicinaZastitneObuce(r[34]);
                    d.setVelicinaZastitneOdjece(r[35]);
                    d.setVelicinaZastiteZaGlavu(r[36]);
                    d.setVelicinaRukavica(r[37]);
                    if (r[38] != null || !r[38].equals("")) {
                        d.setDatumTrajanjaUgovora(UnosDjelatnikaCSVController.parse(r[38]));
                    }
                    d.setEmail(r[39]);
                    d.setPbr(r[40]);
                    d.setKcbr(r[41]);
                }
                ++this.lineNumber;
                return d;
            }).collect(Collectors.toList());
            this.listaDjelatnikaTablica.addAll(this.listaDjelatnika);
        }
        catch (IOException ex) {
            Logger.getLogger(UnosDjelatnikaCSVController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void popuniKoloneUTabliciDjelatnik() {
        try {
            String[] strArray = Files.lines(this.myPath, StandardCharsets.UTF_8).map(s -> s.split(";")).findFirst().get();
            this.tablicaDjelatnikCSV.setEditable(true);
            Callback dateCellFactory = param -> new DateCell();
            TableColumn col0 = new TableColumn("Red.br");
            TableColumn col1 = new TableColumn(strArray[0].toUpperCase());
            TableColumn col2 = new TableColumn(strArray[2].toUpperCase());
            TableColumn col3 = new TableColumn(strArray[1].toUpperCase());
            TableColumn col4 = new TableColumn(strArray[3].toUpperCase());
            TableColumn col5 = new TableColumn(strArray[4].toUpperCase());
            TableColumn col6 = new TableColumn(strArray[5].toUpperCase());
            TableColumn col7 = new TableColumn(strArray[6].toUpperCase());
            TableColumn col10 = new TableColumn(strArray[9].toUpperCase());
            TableColumn col11 = new TableColumn(strArray[10].toUpperCase());
            TableColumn col12 = new TableColumn(strArray[11].toUpperCase());
            TableColumn col013 = new TableColumn(strArray[13].toUpperCase());
            TableColumn col13 = new TableColumn(strArray[17].toUpperCase());
            TableColumn col14 = new TableColumn(strArray[18].toUpperCase());
            TableColumn col15 = new TableColumn(strArray[19].toUpperCase());
            TableColumn col16 = new TableColumn(strArray[20].toUpperCase());
            TableColumn col17 = new TableColumn(strArray[21].toUpperCase());
            TableColumn col18 = new TableColumn(strArray[22].toUpperCase());
            TableColumn col19 = new TableColumn(strArray[23].toUpperCase());
            TableColumn col20 = new TableColumn(strArray[24].toUpperCase());
            TableColumn col21 = new TableColumn(strArray[25].toUpperCase());
            TableColumn col22 = new TableColumn(strArray[26].toUpperCase());
            TableColumn col23 = new TableColumn(strArray[27].toUpperCase());
            TableColumn col24 = new TableColumn(strArray[28].toUpperCase());
            TableColumn col25 = new TableColumn(strArray[29].toUpperCase());
            TableColumn col26 = new TableColumn(strArray[30].toUpperCase());
            TableColumn col27 = new TableColumn(strArray[31].toUpperCase());
            TableColumn col28 = new TableColumn(strArray[32].toUpperCase());
            TableColumn col29 = new TableColumn(strArray[33].toUpperCase());
            TableColumn col30 = new TableColumn(strArray[34].toUpperCase());
            TableColumn col31 = new TableColumn(strArray[35].toUpperCase());
            TableColumn col32 = new TableColumn(strArray[36].toUpperCase());
            TableColumn col33 = new TableColumn(strArray[37].toUpperCase());
            TableColumn col34 = new TableColumn(strArray[38].toUpperCase());
            TableColumn col35 = new TableColumn(strArray[39].toUpperCase());
            TableColumn col36 = new TableColumn(strArray[40].toUpperCase());
            TableColumn col37 = new TableColumn(strArray[41].toUpperCase());
            this.tablicaDjelatnikCSV.getColumns().addAll((Object[])new TableColumn[]{col0, col1, col2, col3, col4, col5, col6, col7, col10, col11, col013, col12, col13, col14, col15, col16, col17, col18, col19, col20, col21, col22, col23, col24, col25, col26, col27, col28, col29, col30, col31, col32, col33, col34, col35, col36, col37});
            col0.setCellValueFactory(data -> ((Djelatnik)data.getValue()).redBrojProperty());
            col1.setCellValueFactory(data -> ((Djelatnik)data.getValue()).sifraDjelatnikaProperty());
            col1.setCellFactory(TextFieldTableCell.forTableColumn());
            col2.setCellValueFactory(data -> ((Djelatnik)data.getValue()).prezimeProperty());
            col2.setCellFactory(TextFieldTableCell.forTableColumn());
            col3.setCellValueFactory(data -> ((Djelatnik)data.getValue()).imeProperty());
            col3.setCellFactory(TextFieldTableCell.forTableColumn());
            col4.setCellValueFactory(data -> ((Djelatnik)data.getValue()).poslovnaJedinicaProperty());
            col4.setCellFactory(TextFieldTableCell.forTableColumn());
            col5.setCellValueFactory(data -> ((Djelatnik)data.getValue()).odjelProperty());
            col5.setCellFactory(TextFieldTableCell.forTableColumn());
            col6.setCellValueFactory(data -> ((Djelatnik)data.getValue()).nazivRukovoditeljaProperty());
            col6.setCellFactory(TextFieldTableCell.forTableColumn());
            col7.setCellValueFactory(data -> ((Djelatnik)data.getValue()).radnoMjestoProperty());
            col7.setCellFactory(TextFieldTableCell.forTableColumn());
            col10.setCellValueFactory(data -> ((Djelatnik)data.getValue()).datumZaposlenjaProperty());
            col10.setCellFactory(dateCellFactory);
            col11.setCellValueFactory(data -> ((Djelatnik)data.getValue()).vrstaZaposlenjaProperty());
            col11.setCellFactory(TextFieldTableCell.forTableColumn());
            col12.setCellValueFactory(data -> ((Djelatnik)data.getValue()).radnoVrijemeProperty());
            col12.setCellFactory(TextFieldTableCell.forTableColumn());
            col013.setCellValueFactory(data -> ((Djelatnik)data.getValue()).stazIzvanTvrtkeProperty());
            col013.setCellFactory(TextFieldTableCell.forTableColumn());
            col13.setCellValueFactory(data -> ((Djelatnik)data.getValue()).spolProperty());
            col13.setCellFactory(TextFieldTableCell.forTableColumn());
            col14.setCellValueFactory(data -> ((Djelatnik)data.getValue()).strucnaSpremaProperty());
            col14.setCellFactory(TextFieldTableCell.forTableColumn());
            col15.setCellValueFactory(data -> ((Djelatnik)data.getValue()).OIBProperty());
            col15.setCellFactory(TextFieldTableCell.forTableColumn());
            col16.setCellValueFactory(data -> ((Djelatnik)data.getValue()).stupanjObrazovanjaProperty());
            col16.setCellFactory(TextFieldTableCell.forTableColumn());
            col17.setCellValueFactory(data -> ((Djelatnik)data.getValue()).datumRodjenjaProperty());
            col17.setCellFactory(dateCellFactory);
            col18.setCellValueFactory(data -> ((Djelatnik)data.getValue()).zanimianjeProperty());
            col18.setCellFactory(TextFieldTableCell.forTableColumn());
            col19.setCellValueFactory(data -> ((Djelatnik)data.getValue()).mjestoRodjenjaProperty());
            col19.setCellFactory(TextFieldTableCell.forTableColumn());
            col20.setCellValueFactory(data -> ((Djelatnik)data.getValue()).opcinaRodjenjaProperty());
            col20.setCellFactory(TextFieldTableCell.forTableColumn());
            col21.setCellValueFactory(data -> ((Djelatnik)data.getValue()).drzavaRodjenjaProperty());
            col21.setCellFactory(TextFieldTableCell.forTableColumn());
            col22.setCellValueFactory(data -> ((Djelatnik)data.getValue()).mjestoStanovanjaProperty());
            col22.setCellFactory(TextFieldTableCell.forTableColumn());
            col23.setCellValueFactory(data -> ((Djelatnik)data.getValue()).adresaProperty());
            col23.setCellFactory(TextFieldTableCell.forTableColumn());
            col24.setCellValueFactory(data -> ((Djelatnik)data.getValue()).imeOcaProperty());
            col24.setCellFactory(TextFieldTableCell.forTableColumn());
            col25.setCellValueFactory(data -> ((Djelatnik)data.getValue()).imeMajkeProperty());
            col25.setCellFactory(TextFieldTableCell.forTableColumn());
            col26.setCellValueFactory(data -> ((Djelatnik)data.getValue()).brOsobneIskazniceProperty());
            col26.setCellFactory(TextFieldTableCell.forTableColumn());
            col27.setCellValueFactory(data -> ((Djelatnik)data.getValue()).brOsiguraneOsobeProperty());
            col27.setCellFactory(TextFieldTableCell.forTableColumn());
            col28.setCellValueFactory(data -> ((Djelatnik)data.getValue()).kontaktTelefonProperty());
            col28.setCellFactory(TextFieldTableCell.forTableColumn());
            col29.setCellValueFactory(data -> ((Djelatnik)data.getValue()).napomenaProperty());
            col29.setCellFactory(TextFieldTableCell.forTableColumn());
            col30.setCellValueFactory(data -> ((Djelatnik)data.getValue()).velicinaZastitneObuceProperty());
            col30.setCellFactory(TextFieldTableCell.forTableColumn());
            col31.setCellValueFactory(data -> ((Djelatnik)data.getValue()).velicinaZastitneOdjeceProperty());
            col31.setCellFactory(TextFieldTableCell.forTableColumn());
            col32.setCellValueFactory(data -> ((Djelatnik)data.getValue()).velicinaZastiteZaGlavuProperty());
            col32.setCellFactory(TextFieldTableCell.forTableColumn());
            col33.setCellValueFactory(data -> ((Djelatnik)data.getValue()).velicinaRukavicaProperty());
            col33.setCellFactory(TextFieldTableCell.forTableColumn());
            col35.setCellValueFactory(data -> ((Djelatnik)data.getValue()).emailProperty());
            col35.setCellFactory(TextFieldTableCell.forTableColumn());
            col36.setCellValueFactory(data -> ((Djelatnik)data.getValue()).pbrProperty());
            col36.setCellFactory(TextFieldTableCell.forTableColumn());
            col37.setCellValueFactory(data -> ((Djelatnik)data.getValue()).kcbrProperty());
            col37.setCellFactory(TextFieldTableCell.forTableColumn());
            this.tablicaDjelatnikCSV.setItems(this.listaDjelatnikaTablica);
        }
        catch (IOException ex) {
            Logger.getLogger(UnosDjelatnikaCSVController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void popuniKoloneUTAbliciPJ() {
        this.tablicaPoslovnaJedinicaCSV.setEditable(true);
        TableColumn col1 = new TableColumn("Oznaka");
        TableColumn col2 = new TableColumn("Naziv");
        col1.setCellValueFactory(data -> ((PoslovneJedinice)data.getValue()).oznakaPoslovniceProperty());
        col1.setCellFactory(TextFieldTableCell.forTableColumn());
        col2.setCellValueFactory(data -> ((PoslovneJedinice)data.getValue()).nazivPoslovniceProperty());
        col2.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tablicaPoslovnaJedinicaCSV.getColumns().addAll((Object[])new TableColumn[]{col1, col2});
        this.tablicaPoslovnaJedinicaCSV.setItems(this.listaPoslovneJedinice);
    }

    private void popuniKoloneUTabliciRM() {
        this.tablicaRadnaMjestaCSV.setEditable(true);
        TableColumn col2 = new TableColumn("Naziv");
        col2.setCellValueFactory(data -> ((RadnoMjesto)data.getValue()).nazivProperty());
        col2.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tablicaRadnaMjestaCSV.getColumns().addAll((Object[])new TableColumn[]{col2});
        this.tablicaRadnaMjestaCSV.setItems(this.listaRadnaMjesta);
    }

    private void unesiUBazu() {
        for (int i = 0; i < this.listaRadnaMjesta.size(); ++i) {
            if (!BazaRadnaMjesta.unesiNovoRadnoMjesto(GlavniPanelController.getOdabranaTvrtka(), (RadnoMjesto)this.listaRadnaMjesta.get(i))) continue;
            this.listaRadnaMjesta.remove(i);
            this.tablicaRadnaMjestaCSV.refresh();
        }
    }

    private void unesiPJUBazu() {
        for (int i = 0; i < this.listaPoslovneJedinice.size(); ++i) {
            if (!BazaPoslovneJedinice.unesiNovuPoslovnicu(GlavniPanelController.getOdabranaTvrtka(), (PoslovneJedinice)this.listaPoslovneJedinice.get(i))) continue;
            this.listaPoslovneJedinice.remove(i);
            this.tablicaRadnaMjestaCSV.refresh();
        }
    }

    private synchronized void unesiDjelatnikeUBazu() {
        for (int i = 0; i < this.listaDjelatnikaTablica.size(); ++i) {
            if (!BazaDjelatnik.unesiNovogDjelatnika(GlavniPanelController.getOdabranaTvrtka(), (Djelatnik)this.listaDjelatnikaTablica.get(i))) continue;
            this.listaDjelatnikaTablica.remove(i);
            this.tablicaDjelatnikCSV.refresh();
        }
    }

    static {
        DATE_FORMATTER = DateTimeFormatter.ofPattern(DATE_PATTERN);
    }
}

