/*
 * Decompiled with CFR 0.152.
 */
package alkotestiranje;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import alkotestiranje.Alkotestiranje;
import alkotestiranje.BazaAlkotestiranje;
import alkotestiranje.PopisAlkotestiranjaController;
import java.net.URL;
import java.time.LocalDate;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import kadrovska.Djelatnik;
import zastitanaradu.GlavniPanelController;

public class UnosAlkotestiranjaController
implements Initializable {
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtImePrezime;
    @FXML
    private TextField txtOib;
    @FXML
    private TextField txtMjestoProvjere;
    @FXML
    private DatePicker dateDatumProvjere;
    @FXML
    private TextField txtSatProvjere;
    @FXML
    private TextField txtPromili;
    @FXML
    private RadioButton rbtnJeProsudba;
    @FXML
    private RadioButton rbtnNijeProsudba;
    @FXML
    private RadioButton rbtnJeZakljucak;
    @FXML
    private RadioButton rbtnNijeZakljucak;
    @FXML
    private TextField txtOvlasteniDjelatnici1;
    @FXML
    private TextField txtOvlasteniDjelatnici2;
    @FXML
    private TextField txtOvlasteniDjelatnici3;
    @FXML
    private TextField txtNazocni1;
    @FXML
    private TextField txtNazocni2;
    @FXML
    private TextField txtNazocni3;
    @FXML
    private TextArea txtAreaOpis;
    private static UnosAlkotestiranjaController instance;
    private ToggleGroup toggleGroupProsudba = new ToggleGroup();
    private ToggleGroup toggleGroupZakljucak = new ToggleGroup();
    private Boolean izmjenaAlkotestiranje = false;
    private Alkotestiranje al = null;
    private Djelatnik d;

    public static UnosAlkotestiranjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.rbtnJeProsudba.setToggleGroup(this.toggleGroupProsudba);
        this.rbtnNijeProsudba.setToggleGroup(this.toggleGroupProsudba);
        this.rbtnJeZakljucak.setToggleGroup(this.toggleGroupZakljucak);
        this.rbtnNijeZakljucak.setToggleGroup(this.toggleGroupZakljucak);
        this.dateDatumProvjere.setValue((Object)LocalDate.now());
        this.btnPretragaDjelatnika.setOnAction(e -> {
            this.d = FxDialogs.getDjelatnikDijalog();
            if (this.d != null) {
                this.popuniOsobu(this.d);
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiAlkotest());
    }

    private void popuniOsobu(Djelatnik d) {
        String imeRoditelja = d.getImeOca().equals("") ? d.getImeMajke() : d.getImeOca();
        this.txtImePrezime.setText(d.getIme() + " (" + imeRoditelja + ") " + d.getPrezime());
        this.txtOib.setText(d.getOIB());
    }

    private void spremiAlkotest() {
        boolean bimeprezime;
        boolean bOib = FormValidation.textFieldValidationonlyText(this.txtOib);
        if (bOib & (bimeprezime = FormValidation.textFieldValidationonlyText(this.txtImePrezime))) {
            if (this.izmjenaAlkotestiranje.booleanValue()) {
                if (BazaAlkotestiranje.izmjenaAlkotestiranja(GlavniPanelController.getOdabranaTvrtka(), this.dajAlkotest(), this.al.getId())) {
                    PopisAlkotestiranjaController.getInstance().popuniTablicuPopisAlkotestiranja();
                    GlavniPanelController.getInstance().zatvoriTab("Unos Alkotestiranja");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena obrasca", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena obrasca", 2, "Error graphic");
                }
            } else if (BazaAlkotestiranje.unesiNoviAlkotest(GlavniPanelController.getOdabranaTvrtka(), this.dajAlkotest())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen obrasc", 1, "Information graphic");
                PopisAlkotestiranjaController.getInstance().popuniTablicuPopisAlkotestiranja();
                GlavniPanelController.getInstance().zatvoriTab("Unos Alkotestiranja");
                this.izmjenaAlkotestiranje = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen obrasc", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private Alkotestiranje dajAlkotest() {
        Alkotestiranje al = new Alkotestiranje();
        al.setOpisProsudbe(this.txtAreaOpis.getText());
        al.setImePrezime(this.txtImePrezime.getText());
        al.setOib(this.txtOib.getText());
        al.setMjestoProvjere(this.txtMjestoProvjere.getText());
        al.setDatumProvjere((LocalDate)this.dateDatumProvjere.getValue());
        al.setSati(this.txtSatProvjere.getText());
        al.setPromili(this.txtPromili.getText());
        if (this.rbtnJeProsudba.isSelected()) {
            al.setProsudbaJeNIje(true);
        }
        if (this.rbtnNijeProsudba.isSelected()) {
            al.setProsudbaJeNIje(false);
        }
        if (this.rbtnJeZakljucak.isSelected()) {
            al.setProsudbaJeNIje(true);
        }
        if (this.rbtnJeZakljucak.isSelected()) {
            al.setZakljucakJeNIje(true);
        }
        if (this.rbtnNijeZakljucak.isSelected()) {
            al.setZakljucakJeNIje(false);
        }
        al.setOvlasteniDjelatnik1(this.txtOvlasteniDjelatnici1.getText());
        al.setOvlasteniDjelatnik2(this.txtOvlasteniDjelatnici2.getText());
        al.setOvlasteniDjelatnik3(this.txtOvlasteniDjelatnici3.getText());
        al.setNazocniDjelatnik1(this.txtNazocni1.getText());
        al.setNazocniDjelatnik2(this.txtNazocni2.getText());
        al.setNazocniDjelatnik3(this.txtNazocni3.getText());
        return al;
    }

    public void izmjenaAlkotestiranja(Alkotestiranje al) {
        this.izmjenaAlkotestiranje = true;
        this.al = al;
        this.txtAreaOpis.setText(al.getOpisProsudbe());
        this.txtImePrezime.setText(al.getImePrezime());
        this.txtOib.setText(al.getOib());
        this.txtMjestoProvjere.setText(al.getMjestoProvjere());
        this.dateDatumProvjere.setValue((Object)al.getDatumProvjere());
        this.txtSatProvjere.setText(al.getSati());
        this.txtPromili.setText(al.getPromili());
        if (al.isProsudbaJeNIje()) {
            this.toggleGroupProsudba.selectToggle((Toggle)this.rbtnJeProsudba);
        } else {
            this.toggleGroupProsudba.selectToggle((Toggle)this.rbtnNijeProsudba);
        }
        if (al.isZakljucakJeNIje()) {
            this.toggleGroupZakljucak.selectToggle((Toggle)this.rbtnJeZakljucak);
        } else {
            this.toggleGroupZakljucak.selectToggle((Toggle)this.rbtnNijeZakljucak);
        }
        this.txtOvlasteniDjelatnici1.setText(al.getOvlasteniDjelatnik1());
        this.txtOvlasteniDjelatnici2.setText(al.getOvlasteniDjelatnik2());
        this.txtOvlasteniDjelatnici3.setText(al.getOvlasteniDjelatnik3());
        this.txtNazocni1.setText(al.getNazocniDjelatnik1());
        this.txtNazocni2.setText(al.getNazocniDjelatnik2());
        this.txtNazocni3.setText(al.getNazocniDjelatnik3());
    }
}

