/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TextAreaTableCell<S, T>
extends TableCell<S, T> {
    private TextArea textArea;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return TextAreaTableCell.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return list -> new TextAreaTableCell(converter);
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    private static <T> TextArea createTextArea(Cell<T> cell, StringConverter<T> converter) {
        TextArea textArea = new TextArea(TextAreaTableCell.getItemText(cell, converter));
        textArea.setOnKeyReleased(t -> {
            KeyCodeCombination combo = new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN});
            if (t.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                t.consume();
            } else if (combo.match(t)) {
                t.consume();
                textArea.appendText("\n");
            } else if (t.getCode() == KeyCode.ENTER) {
                if (converter == null) {
                    throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
                }
                cell.commitEdit(converter.fromString(textArea.getText()));
                t.consume();
            }
        });
        textArea.prefRowCountProperty().bind((ObservableValue)Bindings.size((ObservableList)textArea.getParagraphs()));
        return textArea;
    }

    private void startEdit(Cell<T> cell, StringConverter<T> converter) {
        this.textArea.setText(TextAreaTableCell.getItemText(cell, converter));
        this.setPadding(new Insets(0.0, 30.0, 0.0, 0.0));
        cell.setText(null);
        cell.setGraphic((Node)this.textArea);
        this.textArea.requestFocus();
    }

    private static <T> void cancelEdit(Cell<T> cell, StringConverter<T> converter) {
        cell.setText(TextAreaTableCell.getItemText(cell, converter));
        cell.setGraphic(null);
    }

    private void updateItem(Cell<T> cell, StringConverter<T> converter) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (this.textArea != null) {
                this.textArea.setText(TextAreaTableCell.getItemText(cell, converter));
            }
            cell.setText(null);
            cell.setGraphic((Node)this.textArea);
        } else {
            cell.setText(TextAreaTableCell.getItemText(cell, converter));
            cell.setGraphic(null);
        }
    }

    public TextAreaTableCell() {
        this(null);
    }

    public TextAreaTableCell(StringConverter<T> converter) {
        this.getStyleClass().add((Object)"text-area-table-cell");
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.textArea == null) {
                this.textArea = TextAreaTableCell.createTextArea(this, this.getConverter());
            }
            this.startEdit((Cell<T>)this, this.getConverter());
            this.setPrefHeight(this.textArea.getPrefHeight());
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        TextAreaTableCell.cancelEdit(this, this.getConverter());
        this.setPrefHeight(30.0);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateItem((Cell<T>)this, this.getConverter());
        this.setPrefHeight(30.0);
    }
}

