/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import Utill.KlasaKorisneMetode;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import testovi.BazaTestovi;

public class PDFMerger {
    static File temp = null;

    static void mergePdfFiles(List<InputStream> inputPdfList, OutputStream outputStream) throws Exception {
        Document document = new Document();
        ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
        int totalPages = 0;
        for (InputStream pdf : inputPdfList) {
            PdfReader pdfReader = new PdfReader(pdf);
            readers.add(pdfReader);
            totalPages += pdfReader.getNumberOfPages();
        }
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PdfContentByte pageContentByte = writer.getDirectContent();
        int currentPdfReaderPage = 1;
        for (PdfReader pdfReader : readers) {
            while (currentPdfReaderPage <= pdfReader.getNumberOfPages()) {
                document.newPage();
                PdfImportedPage pdfImportedPage = writer.getImportedPage(pdfReader, currentPdfReaderPage);
                pageContentByte.addTemplate((PdfTemplate)pdfImportedPage, 0.0f, 0.0f);
                ++currentPdfReaderPage;
            }
            currentPdfReaderPage = 1;
        }
        outputStream.flush();
        document.close();
        outputStream.close();
        System.out.println("Pdf files merged successfully.");
    }

    public static void main(String[] args) {
        try {
            byte[] byteImage2 = BazaTestovi.getDokument("Odgovor_ministarstva_zdravstva_pitanja_tumacenje_2009-11-23[1].pdf");
            ArrayList<byte[]> pdfFilesAsByteArray = new ArrayList<byte[]>();
            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File("C:\\Users\\Brna\\Desktop\\ISPITIVNJE VODONEPROPUSNOSTI\\POTVRDA O AKREDITACIJI,INSPEKT-ING 1.pdf"));
            byte[] byteImage1 = KlasaKorisneMetode.ImageToByte(new File("C:\\Users\\Brna\\Desktop\\ISPITIVNJE VODONEPROPUSNOSTI\\RJE\u0160ENJE MINISTARSTVA,INSPEKT-ING 1.pdf"));
            pdfFilesAsByteArray.add(byteImage2);
            pdfFilesAsByteArray.add(byteImage);
            pdfFilesAsByteArray.add(byteImage1);
            ByteArrayInputStream bi = new ByteArrayInputStream(PDFMerger.mergePDF(pdfFilesAsByteArray));
            PDFMerger.writeToFileSystem(bi, "Spojeno.pdf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] mergePDF(List<byte[]> pdfFilesAsByteArray) throws DocumentException, IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Document document = null;
        PdfCopy writer = null;
        for (byte[] pdfByteArray : pdfFilesAsByteArray) {
            try {
                PdfReader reader = new PdfReader(pdfByteArray);
                int numberOfPages = reader.getNumberOfPages();
                if (document == null) {
                    document = new Document(reader.getPageSizeWithRotation(1));
                    writer = new PdfCopy(document, (OutputStream)outStream);
                    document.open();
                }
                int i = 0;
                while (i < numberOfPages) {
                    PdfImportedPage page = writer.getImportedPage(reader, ++i);
                    writer.addPage(page);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        document.close();
        outStream.close();
        return outStream.toByteArray();
    }

    public static void writeToFileSystem(ByteArrayInputStream byteArrayInputStream, String nazivDokumenta) throws Exception {
        System.out.println("usao u export");
        try {
            temp = File.createTempFile(nazivDokumenta, "." + KlasaKorisneMetode.getExtension(new File(nazivDokumenta)));
            temp.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fileOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteArray = new byte[byteArrayInputStream.available()];
        System.out.println("report name na putanji   " + temp.getAbsolutePath());
        fileOutputStream = new FileOutputStream(temp);
        byteArrayOutputStream = new ByteArrayOutputStream(byteArrayInputStream.available());
        int x = byteArrayInputStream.read(byteArray, 0, byteArrayInputStream.available());
        byteArrayOutputStream.write(byteArray, 0, x);
        byteArrayOutputStream.writeTo(fileOutputStream);
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        fileOutputStream.close();
        if (temp.exists()) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(new File(temp.getAbsolutePath()));
                }
                catch (IOException eo) {
                    eo.printStackTrace();
                }
            } else {
                System.out.println("Awt Desktop is not supported!");
            }
        } else {
            System.out.println("File is not exists!");
        }
        System.out.println("zavrsio export");
    }
}

