/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.stage.PopupWindow;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.controlsfx.control.Notifications;

public class KlasaKorisneMetode {
    public static void ispisiSql(String sql) {
        System.out.println(sql);
    }

    public static boolean provjeriOib(String oib) {
        if (oib.length() != 11) {
            return false;
        }
        int ostatak = 10;
        for (int i = 0; i < oib.length() - 1; ++i) {
            int znamenka = Integer.parseInt(oib.substring(i, i + 1));
            int zbroj = znamenka + ostatak;
            int medjuOstatak = zbroj % 10;
            if (medjuOstatak == 0) {
                medjuOstatak = 10;
            }
            int umnozak = medjuOstatak * 2;
            ostatak = umnozak % 11;
        }
        int kontrolniBroj = 11 - ostatak;
        if (kontrolniBroj == 10) {
            kontrolniBroj = 0;
        }
        return Integer.parseInt(oib.substring(10, 11)) == kontrolniBroj;
    }

    public static byte[] ImageToByte(File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException readNum) {
            // empty catch block
        }
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    public static void byteToImage(byte[] bytes, File imageFile) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("jpeg");
        ImageReader reader = readers.next();
        ByteArrayInputStream source = bis;
        ImageInputStream iis = ImageIO.createImageInputStream(source);
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        BufferedImage image = reader.read(0, param);
        BufferedImage bufferedImage = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", imageFile);
        System.out.println(imageFile.getPath());
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private Tooltip makeBubble(Tooltip tooltip) {
        String SQUARE_BUBBLE = "M24 1h-24v16.981h4v5.019l7-5.019h13z";
        tooltip.setStyle("-fx-font-size: 12px; -fx-shape: \"M24 1h-24v16.981h4v5.019l7-5.019h13z\";");
        tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_BOTTOM_LEFT);
        return tooltip;
    }

    public static Notifications kreirajNotifikaciju(Pos pos, String text, int duration, String graphicMode) {
        Notifications notificationBuilder = null;
        notificationBuilder = Notifications.create().title("Poruka").text(text).hideAfter(Duration.seconds((double)duration)).position(pos).darkStyle();
        switch (graphicMode) {
            case "Warning graphic": {
                notificationBuilder.showWarning();
                break;
            }
            case "Information graphic": {
                notificationBuilder.showInformation();
                break;
            }
            case "Confirm graphic": {
                notificationBuilder.showConfirm();
                break;
            }
            case "Error graphic": {
                notificationBuilder.showError();
                break;
            }
            default: {
                notificationBuilder.show();
            }
        }
        return notificationBuilder;
    }

    public static Notifications kreirajNotifikacijuPoruka(Pos pos, String text, int duration, String graphicMode, Node n) {
        Notifications notificationBuilder = null;
        notificationBuilder = Notifications.create().title("Poruka").text(text).owner((Object)n).hideAfter(Duration.seconds((double)duration)).position(pos).darkStyle();
        switch (graphicMode) {
            case "Warning graphic": {
                notificationBuilder.showWarning();
                break;
            }
            case "Information graphic": {
                notificationBuilder.showInformation();
                break;
            }
            case "Confirm graphic": {
                notificationBuilder.showConfirm();
                break;
            }
            case "Error graphic": {
                notificationBuilder.showError();
                break;
            }
            default: {
                notificationBuilder.show();
            }
        }
        return notificationBuilder;
    }

    public static String StringToDate(String datumS) {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyy");
        Date today = null;
        try {
            today = df.parse(datumS);
        }
        catch (ParseException ex) {
            Logger.getLogger(KlasaKorisneMetode.class.getName()).log(Level.SEVERE, null, ex);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String s = formatter.format((Object)today);
        System.out.println("Today = " + s);
        return s;
    }

    public static String fixPathForDatabase(String path) {
        if (path == null) {
            return path;
        }
        String result = "";
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '\\' && path.charAt(i + 1) == '\\') {
                return path;
            }
            if (path.charAt(i) == '\\') {
                result = result + '\\';
            }
            result = result + path.charAt(i);
        }
        return result;
    }

    public static String formatirajDoubleUCijenu(String broj) {
        Double d = KlasaKorisneMetode.pretvaraBrojSZarezomUDouble(broj);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(',');
        DecimalFormat dc = new DecimalFormat("#,##0.00 kn", dfs);
        return dc.format(d);
    }

    public static double pretvaraBrojSZarezomUDouble(String p) {
        char znak = ',';
        int count = 0;
        int i = 0;
        double d = 0.0;
        String broj = null;
        if (!p.equalsIgnoreCase("")) {
            do {
                if (p.charAt(i) != znak) continue;
                broj = p.replace(znak, '.');
                if (++count != 2) continue;
                broj = null;
                break;
            } while (count < 2 && ++i < p.length());
            d = broj != null ? Double.valueOf(broj) : 0.0;
            if (count == 0) {
                d = Double.valueOf(p);
            }
        }
        return d;
    }

    public static String formatirajDoubleZaKolicinu(String broj) {
        Double d = KlasaKorisneMetode.izvadiBrojUDouble(broj);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(',');
        DecimalFormat dc = new DecimalFormat("#,##0.000", dfs);
        return dc.format(d);
    }

    public static String formatirajDoubleZaCijenu(Double broj) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(',');
        DecimalFormat dc = new DecimalFormat("#,##0.00", dfs);
        return dc.format(broj);
    }

    public static Double izvadiBrojUDouble(String broj) {
        String brojTemp = "";
        if (!broj.equals("")) {
            StringTokenizer st = new StringTokenizer(broj, "kn");
            while (st.hasMoreTokens()) {
                brojTemp = st.nextToken();
            }
        }
        return KlasaKorisneMetode.pretvaraBrojSZarezomUDouble(brojTemp);
    }

    public static String vadiBrojizFormatiraneCijene(String cijena) {
        StringTokenizer st = new StringTokenizer(cijena, "kn.");
        String broj = "";
        StringBuffer sb = new StringBuffer(broj);
        while (st.hasMoreTokens()) {
            broj = st.nextToken();
            sb.append(broj);
        }
        return sb.toString();
    }

    public static String izvadiBrojizFormatiraneKolicine(String kolicina) {
        StringTokenizer st = new StringTokenizer(kolicina, "kn.");
        String broj = "";
        StringBuilder sb = new StringBuilder(broj);
        while (st.hasMoreTokens()) {
            broj = st.nextToken();
            sb.append(broj);
        }
        return sb.toString();
    }

    public static Double vadiDoubleIzFormatiraneCijene(String s) {
        StringTokenizer st = new StringTokenizer(s, "kn.");
        String broj = "";
        StringBuilder sb = new StringBuilder(broj);
        while (st.hasMoreTokens()) {
            broj = st.nextToken();
            sb.append(broj);
        }
        return KlasaKorisneMetode.pretvaraBrojSZarezomUDouble(sb.toString());
    }

    public static Double vadiDoublezFormatiraneKolicine(String s) {
        StringTokenizer st = new StringTokenizer(s, "kn.");
        String broj = "";
        StringBuilder sb = new StringBuilder(broj);
        while (st.hasMoreTokens()) {
            broj = st.nextToken();
            sb.append(broj);
        }
        return KlasaKorisneMetode.pretvaraBrojSZarezomUDouble(sb.toString());
    }

    public static Double vadiDoubleIzFormatiranogPostotka(String s) {
        StringTokenizer st = new StringTokenizer(s, "'%'.");
        String broj = "";
        StringBuilder sb = new StringBuilder(broj);
        while (st.hasMoreTokens()) {
            broj = st.nextToken();
            sb.append(broj);
        }
        return KlasaKorisneMetode.pretvaraBrojSZarezomUDouble(sb.toString());
    }
}

