/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import Utill.DateUtil;
import Utill.FxUtil;
import Utill.FxUtilTest;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import filter.ComboBoxUtill;
import ispitivaci.BazaIspitivac;
import ispitivaci.Ispitivac;
import java.awt.Robot;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.Pair;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import kadrovska.UnosDjelatnikaController;
import osposobljavanje.BazaOsposobljavanje;
import osposobljavanje.Osposobljavanje;
import ozljedanaradu.BazaOzljedaNaRadu;
import ozljedanaradu.OzljedaNaRadu;
import ozs.BazaOZS;
import ozs.Ozs;
import radnamjesta.BazaRadnaMjesta;
import radnamjesta.RadnoMjesto;
import strojevi.BazaProizvodjac;
import strojevi.Strojevi;
import zastitanaradu.GlavniPanelController;
import zos.UnosOsposibljavanjaZOSController;
import zrastvenaustanova.BazaZdrastvenaUstanova;
import zrastvenaustanova.ZdrastvenaUstanova;

public class FxDialogs {
    public static final String YES = "DA";
    public static final String NO = "NE";
    public static final String OK = "Unesi";
    public static final String CANCEL = "Odustani";

    public static Alert getDialog(Alert.AlertType alertType, String headerText, String contentText) {
        Alert alert = new Alert(alertType);
        alert.initStyle(StageStyle.TRANSPARENT);
        alert.setTitle("Confirmation Dialog");
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        DialogPane dialogPane = alert.getDialogPane();
        ((Button)dialogPane.lookupButton(ButtonType.OK)).setText("U redu");
        if (alertType == Alert.AlertType.CONFIRMATION) {
            ((Button)dialogPane.lookupButton(ButtonType.OK)).setText(YES);
            ((Button)dialogPane.lookupButton(ButtonType.CANCEL)).setText(NO);
        }
        if (GlavniPanelController.getInstance() != null) {
            dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        }
        return alert;
    }

    public static void showInformation(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.initStyle(StageStyle.UTILITY);
        alert.setTitle("Information");
        alert.setHeaderText(title);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public static void showWarning(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.initStyle(StageStyle.UTILITY);
        alert.setTitle("Warning");
        alert.setHeaderText(title);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public static void showError(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.initStyle(StageStyle.UTILITY);
        alert.setTitle("Error");
        alert.setHeaderText(title);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public static void showException(String title, String message, Exception exception) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.initStyle(StageStyle.TRANSPARENT);
        alert.setTitle("Exception");
        alert.setHeaderText(title);
        alert.setContentText(message);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        String exceptionText = sw.toString();
        Label label = new Label("Details:");
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        alert.showAndWait();
    }

    public static String showConfirm(String title, String message, String ... options) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initStyle(StageStyle.UTILITY);
        alert.setTitle("Choose an option");
        alert.setHeaderText(title);
        alert.setContentText(message);
        alert.getDialogPane().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                event.consume();
                try {
                    Robot r = new Robot();
                    r.keyPress(32);
                    r.keyRelease(32);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (options == null || options.length == 0) {
            options = new String[]{OK, CANCEL};
        }
        ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
        for (String option : options) {
            buttons.add(new ButtonType(option));
        }
        alert.getButtonTypes().setAll(buttons);
        Optional result = alert.showAndWait();
        if (!result.isPresent()) {
            return CANCEL;
        }
        return ((ButtonType)result.get()).getText();
    }

    public static TextInputDialog showTextInput(String title, String message, String defaultValue, Node sadrzaj) {
        TextInputDialog dialog = new TextInputDialog(defaultValue);
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.setTitle("Input");
        dialog.setHeaderText(title);
        dialog.setContentText(message);
        dialog.getDialogPane().setContent(sadrzaj);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Djelatnik getDjelatnikDijalog() {
        ObservableList listaDjelatnika = FXCollections.observableArrayList();
        ResultSet rs = BazaDjelatnik.dajDjelatnike(GlavniPanelController.getOdabranaTvrtka(), BazaDjelatnik.Opcije.zaposlene_djelatnike);
        Djelatnik d = null;
        int br = 1;
        try {
            while (rs.next()) {
                d = new Djelatnik();
                d.setId(rs.getInt("id"));
                d.setRedBroj(String.valueOf(br));
                d.setSifraDjelatnika(rs.getString("sifradjelatnika"));
                d.setOIB(rs.getString("oib"));
                d.setIme(rs.getString("ime"));
                d.setPrezime(rs.getString("prezime"));
                d.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                d.setOdjel(rs.getString("nazivodjela"));
                d.setNazivRukovoditelja(rs.getString("nazivrukovoditelja"));
                d.setRadnoMjesto(rs.getString("rmnaziv"));
                d.setPur(rs.getBoolean("pur"));
                d.setDatumPocetkaPUR(DateUtil.getLocalDate(rs.getDate("datumpocetkapur")));
                d.setDatumZaposlenja(DateUtil.getLocalDate(rs.getDate("datumzaposlenja")));
                d.setVrstaZaposlenja(rs.getString("vrstazaposlenja"));
                d.setRadnoVrijeme(rs.getString("radnovrijeme"));
                d.setStazUTvrtci(rs.getString("stazutvrtci"));
                d.setStazIzvanTvrtke(rs.getString("stazizvantvrtke"));
                d.setOdjavljen(rs.getBoolean("odjavljen"));
                d.setDatumOdjave(DateUtil.getLocalDate(rs.getDate("datumodjave")));
                d.setRazlogOdjave(rs.getString("razlogodjave"));
                d.setSpol(rs.getString("spol"));
                d.setStrucnaSprema(rs.getString("nazivss"));
                d.setStupanjObrazovanja(rs.getString("nazivso"));
                d.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                d.setZanimianje(rs.getString("zanimanje"));
                d.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                d.setOpcinaRodjenja(rs.getString("opcinarodjenja"));
                d.setDrzavaRodjenja(rs.getString("drzava"));
                d.setMjestoStanovanja(rs.getString("mjestostanovanja"));
                d.setAdresa(rs.getString("adresa"));
                d.setImeOca(rs.getString("imeoca"));
                d.setImeMajke(rs.getString("imemajke"));
                d.setBrOsobneIskaznice(rs.getString("brojosobne"));
                d.setBrOsiguraneOsobe(rs.getString("brojosiguraneosobe"));
                d.setKontaktTelefon(rs.getString("kontakttelefon"));
                d.setNapomena(rs.getString("napomena"));
                d.setVelicinaZastitneObuce(rs.getString("velicinaobuce"));
                d.setVelicinaZastitneOdjece(rs.getString("velicinaodjece"));
                d.setVelicinaZastiteZaGlavu(rs.getString("velicinazaglavu"));
                d.setVelicinaRukavica(rs.getString("velicinarukavica"));
                d.setDatumTrajanjaUgovora(DateUtil.getLocalDate(rs.getDate("datumtrajanjaugovora")));
                d.setEmail(rs.getString("email"));
                d.setPbr(rs.getString("pbr"));
                d.setKcbr(rs.getString("kcbr"));
                d.setOznakaNKZ(rs.getString("oznakankz"));
                d.setNazivIsprave(rs.getString("nazivisprave"));
                d.setZdrastvenoStanje(rs.getString("zdrastvenostanje"));
                d.setPsiholoskoStanje(rs.getString("psiholoskostanje"));
                d.setNocniRad(rs.getBoolean("nocnirad"));
                d.setDatumIzdavanjaOI(DateUtil.getLocalDate(rs.getDate("datumizdavanjaoi")));
                listaDjelatnika.add((Object)d);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final TableView<Djelatnik> t = FxDialogs.getTablica((ObservableList<Djelatnik>)listaDjelatnika);
        dialog.setHeaderText("Izaberite djelatnika:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.getDialogPane().setContent(t);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.setPrefSize(750.0, 600.0);
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Djelatnik>(){

            public Djelatnik call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Djelatnik)t.getSelectionModel().getSelectedItem();
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Djelatnik)result.get();
        }
        return null;
    }

    private static TableView<Djelatnik> getTablica(ObservableList<Djelatnik> listaDjelatnika) {
        TableView t = new TableView(listaDjelatnika);
        TableColumn kolOIB = new TableColumn("OIB");
        kolOIB.setCellValueFactory((Callback)new PropertyValueFactory("OIB"));
        kolOIB.prefWidthProperty().bind((ObservableValue)t.widthProperty().divide(5.0));
        kolOIB.setStyle("-fx-alignment: CENTER;");
        TableColumn kolIme = new TableColumn("Ime");
        kolIme.setCellValueFactory((Callback)new PropertyValueFactory("ime"));
        kolIme.prefWidthProperty().bind((ObservableValue)t.widthProperty().divide(3.3333333333333335));
        kolIme.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPrezime = new TableColumn("Prezime");
        kolPrezime.setCellValueFactory((Callback)new PropertyValueFactory("prezime"));
        kolPrezime.prefWidthProperty().bind((ObservableValue)t.widthProperty().divide(2.2222222222222223));
        kolPrezime.setStyle("-fx-alignment: CENTER;");
        TableColumn colonaPretraga = new TableColumn();
        colonaPretraga.setPrefWidth(300.0);
        ToolBar tbFilter = new ToolBar();
        TextField tfilter = new TextField();
        tfilter.setId("textField");
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"OIB", "Prezime"});
        ComboBox cbFilter = new ComboBox(filter);
        cbFilter.setValue((Object)"Prezime");
        tbFilter.setMaxHeight(20.0);
        cbFilter.setPrefWidth(120.0);
        cbFilter.setPrefHeight(25.0);
        tfilter.setPrefWidth(200.0);
        tfilter.setPrefHeight(25.0);
        tbFilter.getItems().addAll((Object[])new Node[]{tfilter, cbFilter});
        colonaPretraga.setGraphic((Node)tbFilter);
        colonaPretraga.getColumns().addAll((Object[])new TableColumn[]{kolOIB, kolPrezime, kolIme});
        t.getColumns().add((Object)colonaPretraga);
        FilteredList filteredData = new FilteredList(listaDjelatnika, p -> true);
        tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return cbFilter.getSelectionModel().getSelectedItem().equals("OIB") ? pregled.getOIB() != null && pregled.getOIB().toLowerCase().startsWith(lowerCaseFilter) : cbFilter.getSelectionModel().getSelectedItem().equals("Prezime") && pregled.getPrezime() != null && pregled.getPrezime().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)t.comparatorProperty());
        t.setItems((ObservableList)sortedData);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialog<Pair<String, String>> getDialogNKZ10() {
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox();
        comboBox.setCellFactory(cb -> new ListCell<Pair<String, String>>(){

            protected void updateItem(Pair<String, String> item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText((String)item.getKey());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    Pair rm = (Pair)t;
                    String str = (String)rm.getKey();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        Konekcija k = new Konekcija();
        String SQL = "select * from zamimanjankz  ";
        KlasaKorisneMetode.ispisiSql(SQL);
        ResultSet rs = k.getResultSet(SQL, true);
        try {
            while (rs.next()) {
                comboBox.getItems().add((Object)new Pair((Object)rs.getString("naziv"), (Object)rs.getString("sifra")));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        comboBox.setPromptText("Odaberite  Zanimanje");
        comboBox.setEditable(true);
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> ((String)itemToCompare.getKey()).toLowerCase().startsWith(typedText.toLowerCase()));
        FxUtilTest.getComboBoxValue(comboBox);
        dialog.setHeaderText("Popis zanimanja (NKZ-10 specifikacija):");
        dialog.initStyle(StageStyle.TRANSPARENT);
        VBox vb = new VBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == buttonTypeOk) {
                return (Pair)FxUtilTest.getComboBoxValue(comboBox);
            }
            return null;
        });
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialog<Pair<String, String>> getDialogDjelatnosti() {
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox();
        comboBox.setCellFactory(cb -> new ListCell<Pair<String, String>>(){

            protected void updateItem(Pair<String, String> item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText((String)item.getKey());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    Pair rm = (Pair)t;
                    String str = (String)rm.getKey();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        Konekcija k = new Konekcija();
        String SQL = "select * from popisdjelatnostinkd  ";
        KlasaKorisneMetode.ispisiSql(SQL);
        ResultSet rs = k.getResultSet(SQL, true);
        try {
            while (rs.next()) {
                comboBox.getItems().add((Object)new Pair((Object)rs.getString("naziv"), (Object)rs.getString("sifra")));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        comboBox.setPromptText("Odaberite  djelatnost");
        comboBox.setEditable(true);
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> ((String)itemToCompare.getKey()).toLowerCase().startsWith(typedText.toLowerCase()));
        FxUtilTest.getComboBoxValue(comboBox);
        dialog.setHeaderText("Nacionalna klasifikacija djelatnosti (NKD):");
        dialog.initStyle(StageStyle.TRANSPARENT);
        VBox vb = new VBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == buttonTypeOk) {
                return (Pair)FxUtilTest.getComboBoxValue(comboBox);
            }
            return null;
        });
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Strojevi getDialogNazivStrojeva() {
        ResultSet rs = BazaProizvodjac.dajStrojeve(GlavniPanelController.getOdabranaTvrtka());
        ObservableList listaStrojeva = FXCollections.observableArrayList();
        Strojevi s = null;
        try {
            while (rs.next()) {
                s = new Strojevi();
                s.setId(rs.getInt("id"));
                s.setNaziv(rs.getString("naziv"));
                s.setOznaka(rs.getString("oznaka"));
                listaStrojeva.add((Object)s);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(listaStrojeva);
        comboBox.setCellFactory(cb -> new ListCell<Strojevi>(){

            protected void updateItem(Strojevi item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getNaziv());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    Strojevi rm = (Strojevi)t;
                    String str = rm.getNaziv();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Naziv ");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getNaziv().toLowerCase().startsWith(typedText.toLowerCase()));
        dialog.setHeaderText("Odaberite stroj, ure\u0111aj ili vatrogasni aparat:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Strojevi>(){

            public Strojevi call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Strojevi)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Strojevi)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RadnoMjesto getRadnoMjestoDijalog() {
        ObservableList radnaMjesta = FXCollections.observableArrayList();
        ResultSet rs = BazaRadnaMjesta.dajRadnaMjesta(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                RadnoMjesto rm = new RadnoMjesto();
                rm.setId(rs.getInt("id"));
                rm.setPur(rs.getString("pur"));
                rm.setNaziv(rs.getString("naziv"));
                rm.setOpasnostiRM(rs.getString("opasnosti"));
                rm.setClanak(rs.getString("clanak"));
                rm.setTockePregleda(rs.getString("tockepregleda"));
                rm.setDobZivota(rs.getString("dobzivota"));
                rm.setSpol(rs.getString("spol"));
                rm.setStrucnaSprema(rs.getString("strucnasprema"));
                rm.setZdrastvenoStanje(rs.getString("zdrastvenostanje"));
                rm.setPsihoSposobnost(rs.getString("psihosposobnost"));
                rm.setOpisPosla(rs.getString("opisposla"));
                rm.setStrojevi(rs.getString("strojevi"));
                rm.setPredmeti(rs.getString("predmeti"));
                rm.setMRuZatvorenom(rs.getBoolean("mruzatvorenom"));
                rm.setMRnaOtvorenom(rs.getBoolean("mrnaotvorenom"));
                rm.setMRnaVisini(rs.getBoolean("mrnavisini"));
                rm.setMRuJami(rs.getBoolean("mrujami"));
                rm.setMRuVodi(rs.getBoolean("mruvodi"));
                rm.setMRpodVodom(rs.getBoolean("mrpodvodom"));
                rm.setMRuMokrom(rs.getBoolean("mrumokrom"));
                rm.setORuSmjenama(rs.getBoolean("orusmjenama"));
                rm.setORnocniRad(rs.getBoolean("ornocnorad"));
                rm.setORterenskiRad(rs.getBoolean("orterenskirad"));
                rm.setORradiSam(rs.getBoolean("orradisam"));
                rm.setORradUGrupama(rs.getBoolean("orradugrupama"));
                rm.setORradSaStrankama(rs.getBoolean("orradsastrankama"));
                rm.setORradNaTraci(rs.getBoolean("orradnatraci"));
                rm.setORbrziTempoRada(rs.getBoolean("orbrzitemporada"));
                rm.setORritamOdredjen(rs.getBoolean("orritamodredjen"));
                rm.setORmonotonija(rs.getBoolean("ormonotomija"));
                rm.setPTradStojeci(rs.getBoolean("ptradstojeci"));
                rm.setPTradSjedeci(rs.getBoolean("ptradsjedeci"));
                rm.setPTradUPokretu(rs.getBoolean("ptradupokretu"));
                rm.setPTKombinirano(rs.getBoolean("ptkombinirano"));
                rm.setPTdizanjeTereta(rs.getBoolean("ptdizanjetereta"));
                rm.setPTDizanjeTeretaKg(rs.getString("ptdizanjeteretakg"));
                rm.setPTUcestaloSagibanje(rs.getBoolean("ptucestalosagibanje"));
                rm.setPTzakretanjeTrupa(rs.getBoolean("ptzakretanjetrupa"));
                rm.setPTklecanje(rs.getBoolean("ptklecanje"));
                rm.setPTcucanje(rs.getBoolean("ptcucanje"));
                rm.setPTprenosTereta(rs.getBoolean("ptprenostereta"));
                rm.setPTprenosTeretaKg(rs.getString("ptprenosteretakg"));
                rm.setPTpodvlacenje(rs.getBoolean("ptpodvlacenje"));
                rm.setPTbalansiranje(rs.getBoolean("ptbalansiranje"));
                rm.setPTuspinjanjeLjestvama(rs.getBoolean("ptuspinjanjeljestvama"));
                rm.setPTuspinjanjeStepenicama(rs.getBoolean("ptuspinjanjestepenicama"));
                rm.setPTguranjeTereta(rs.getBoolean("ptguranjetereta"));
                rm.setPTguranjeTeretaKg(rs.getString("ptguranjeteretakg"));
                rm.setVidNaDaljinu(rs.getBoolean("vidnadaljinu"));
                rm.setVidNaBlizinu(rs.getBoolean("vidnablizinu"));
                rm.setRaspoznavanjeBoja(rs.getBoolean("raspoznavanjeboja"));
                rm.setDobarSluh(rs.getBoolean("dobarsluh"));
                rm.setJasanGovor(rs.getBoolean("jasangovor"));
                rm.setVisokaTemperatura(rs.getBoolean("visokatemperatura"));
                rm.setVisokaVlaznost(rs.getBoolean("visokavlaznost"));
                rm.setNiskaTemperatura(rs.getBoolean("niskatemperatura"));
                rm.setBuka(rs.getBoolean("buka"));
                rm.setVibracijeStroja(rs.getBoolean("vibracijastroja"));
                rm.setVibracijePoda(rs.getBoolean("vibracijapoda"));
                rm.setPovisenATTlak(rs.getBoolean("povisenattlak"));
                rm.setPovecanaIzloOzljedama(rs.getBoolean("povecanaizlozenostozljedama"));
                rm.setIonizaciskoZracenje(rs.getBoolean("ionizaciskozracenje"));
                rm.setNeionizaciskoZracenje(rs.getBoolean("neionizaciskozracenje"));
                rm.setPrasina(rs.getBoolean("prasina"));
                rm.setKemiskeTvari(rs.getString("kemisketveri"));
                rm.setBioloskeStetnosti(rs.getString("bioloskestetnosti"));
                radnaMjesta.add((Object)rm);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(radnaMjesta);
        comboBox.setCellFactory(cb -> new ListCell<RadnoMjesto>(){

            protected void updateItem(RadnoMjesto item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getNaziv());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    RadnoMjesto rm = (RadnoMjesto)t;
                    String str = rm.getNaziv();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Odaberite radno mjesto");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getNaziv().toLowerCase().startsWith(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite radno mjesto:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, RadnoMjesto>(){

            public RadnoMjesto call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (RadnoMjesto)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (RadnoMjesto)result.get();
        }
        return null;
    }

    public static String prikaziDialogMjesto() {
        ObservableList mjesta = FXCollections.observableArrayList();
        ResultSet rs = BazaDjelatnik.dajMjesta();
        try {
            while (rs.next()) {
                mjesta.add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(mjesta);
        comboBox.setPromptText("Odaberite  mjesto");
        FxUtil.autoCompleteComboBox(comboBox, FxUtil.AutoCompleteMode.STARTS_WITH);
        dialog.setHeaderText("Izaberite  mjesto:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.getDialogPane().setContent((Node)new VBox(new Node[]{comboBox}));
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, String>(){

            public String call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (String)comboBox.getSelectionModel().getSelectedItem();
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (String)result.get();
        }
        return null;
    }

    public static String getDialogDrzave() {
        ObservableList drzave = FXCollections.observableArrayList();
        ResultSet rs = BazaDjelatnik.dajDrzave();
        try {
            while (rs.next()) {
                drzave.add((Object)rs.getString("naziv_ispis"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(drzave);
        comboBox.setPromptText("Odaberite  dr\u017eavu");
        FxUtil.autoCompleteComboBox(comboBox, FxUtil.AutoCompleteMode.STARTS_WITH);
        comboBox.getSelectionModel().select((Object)"Hrvatska");
        dialog.setHeaderText("Izaberite  drzavu:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.getDialogPane().setContent((Node)new VBox(new Node[]{comboBox}));
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, String>(){

            public String call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (String)comboBox.getSelectionModel().getSelectedItem();
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (String)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Osposobljavanje getOsposobljavanjaDijalog() {
        ObservableList osposobljavanja = FXCollections.observableArrayList();
        ResultSet rs = BazaOsposobljavanje.dajOsposobljavanja(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                Osposobljavanje o = new Osposobljavanje();
                o.setId(rs.getInt("id"));
                o.setOznaka(rs.getString("oznaka"));
                o.setNazivOsposobljavanja(rs.getString("nazivosposobljavanja"));
                osposobljavanja.add((Object)o);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(osposobljavanja);
        comboBox.setCellFactory(cb -> new ListCell<Osposobljavanje>(){

            protected void updateItem(Osposobljavanje item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getOznaka() + "-" + item.getNazivOsposobljavanja());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    Osposobljavanje rm = (Osposobljavanje)t;
                    String str = rm.getOznaka() + "-" + rm.getNazivOsposobljavanja();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Izaberite osposobljavanje");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> (itemToCompare.getOznaka().toLowerCase() + itemToCompare.getNazivOsposobljavanja().toLowerCase()).contains(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite osposobljavanje:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Osposobljavanje>(){

            public Osposobljavanje call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Osposobljavanje)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Osposobljavanje)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ozs getOZODijalog() {
        ObservableList listaOZS = FXCollections.observableArrayList();
        ResultSet rs = BazaOZS.dajOZS(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                Ozs o = new Ozs();
                o.setId(rs.getInt("id"));
                o.setOznaka(rs.getString("oznaka"));
                o.setNaziv(rs.getString("naziv"));
                listaOZS.add((Object)o);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(listaOZS);
        comboBox.setCellFactory(cb -> new ListCell<Ozs>(){

            protected void updateItem(Ozs item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getNaziv());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    Ozs rm = (Ozs)t;
                    String str = rm.getNaziv();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Izaberite ozo");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getNaziv().toLowerCase().startsWith(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite ozo:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Ozs>(){

            public Ozs call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Ozs)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Ozs)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OzljedaNaRadu getORDijalog() {
        ObservableList listaOZS = FXCollections.observableArrayList();
        ResultSet rs = BazaOzljedaNaRadu.dajOzljede(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                OzljedaNaRadu oz = new OzljedaNaRadu();
                oz.setId(rs.getInt("id"));
                oz.setTxt1(rs.getString("a1"));
                oz.setTxt2(rs.getString("a2"));
                oz.setTxt3(rs.getString("a3"));
                oz.setTxt4(rs.getString("a4"));
                oz.setTxt5(rs.getString("a5"));
                oz.setTxt6(rs.getString("a6"));
                oz.setTxt7(rs.getString("a7"));
                oz.setTxt8(rs.getString("a8"));
                oz.setTxt9(rs.getString("b9"));
                oz.setDatum10(DateUtil.getLocalDate(rs.getDate("b10")));
                oz.setTxt11Ulica(rs.getString("b11ulica"));
                oz.setTxt11KCbr(rs.getString("b11kcbr"));
                oz.setTxt11Mjesto(rs.getString("b11mjesto"));
                oz.setTxt11PBr(rs.getString("b11pbr"));
                oz.setTxt11Tel(rs.getString("b11tel"));
                oz.setTxt11Email(rs.getString("b11email"));
                oz.setTxt12(rs.getString("b12"));
                oz.setTxt13(rs.getString("b13"));
                oz.setTxt14(rs.getString("b14"));
                oz.setTxt15(rs.getString("b15"));
                oz.setTxt15Nazivdrzavljanstva(rs.getString("b15drzavljanstvo"));
                oz.setTxt16(rs.getString("b16"));
                oz.setTxt17(rs.getString("b17"));
                oz.setTxt18(rs.getString("b18"));
                oz.setTxt19OD(rs.getString("b19od"));
                oz.setTxt19DO(rs.getString("b19do"));
                oz.setTxt20(rs.getString("b20"));
                oz.setTxt21(rs.getString("b21"));
                oz.setTxt22(rs.getString("b22"));
                oz.setDatum23(DateUtil.getLocalDate(rs.getDate("c23")));
                oz.setTxt24(rs.getString("c24"));
                oz.setTxt25(rs.getString("c25"));
                oz.setTxt26(rs.getString("c26"));
                oz.setTxt27(rs.getString("c27"));
                oz.setTxt28(rs.getString("c28"));
                oz.setTxt29(rs.getString("c29"));
                oz.setTxt30(rs.getString("c30"));
                oz.setTxt31(rs.getString("c31"));
                oz.setTxt32(rs.getString("c32"));
                oz.setTxt33(rs.getString("c33"));
                oz.setTxt34(rs.getString("c34"));
                oz.setTxt35(rs.getString("c35"));
                oz.setTxt36(rs.getString("c36"));
                oz.setTxt37(rs.getString("c37"));
                oz.setTxt38(rs.getString("c38"));
                oz.setTxt39(rs.getString("c39"));
                oz.setTxt40(rs.getString("c40"));
                oz.setTxt41(rs.getString("c41"));
                oz.setTxt42(rs.getString("c42"));
                oz.setTxt43(rs.getString("c43"));
                oz.setTxt44(rs.getString("c44"));
                oz.setTxt45(rs.getString("c45"));
                oz.setTxt45Opis(rs.getString("c45opis"));
                oz.setTxt46(rs.getString("c46"));
                oz.setTxt47(rs.getString("c47"));
                oz.setTxt48Ime(rs.getString("d48ime"));
                oz.setTxt48Tel(rs.getString("d48tel"));
                oz.setTxt49Adresa(rs.getString("d49adresa"));
                oz.setTxt49Email(rs.getString("d49email"));
                oz.setTxt50Ime(rs.getString("e50ime"));
                oz.setTxt50Tel(rs.getString("e50tel"));
                oz.setTxt51Adresa(rs.getString("e51adresa"));
                oz.setTxt51Email(rs.getString("e51email"));
                oz.setTxt52Ime(rs.getString("f52ime"));
                oz.setTxt52Tel(rs.getString("f52tel"));
                oz.setTxt53RadnoMjesto(rs.getString("f53radnomjesto"));
                oz.setTxt53Email(rs.getString("f53email"));
                oz.setDatumPodnosenjaPrijave(DateUtil.getLocalDate(rs.getDate("datumpodnosenjaprijave")));
                oz.setOdgovornaOsoba(rs.getString("imeprezimeodgovorneosobe"));
                listaOZS.add((Object)oz);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(listaOZS);
        comboBox.setCellFactory(cb -> new ListCell<OzljedaNaRadu>(){

            protected void updateItem(OzljedaNaRadu item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getTxt9() + " - " + item.getDatumPodnosenjaPrijave().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    OzljedaNaRadu rm = (OzljedaNaRadu)t;
                    String str = rm.getTxt9();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Izaberite OR");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getTxt9().toLowerCase().startsWith(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite prijavu ozljede na radu (OR):");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, OzljedaNaRadu>(){

            public OzljedaNaRadu call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (OzljedaNaRadu)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (OzljedaNaRadu)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ispitivac getIspitivaciDijalog() {
        ObservableList listaIspitivaca = FXCollections.observableArrayList();
        ResultSet rs = BazaIspitivac.dajIspitivace(GlavniPanelController.getOdabranaTvrtka());
        Ispitivac is = null;
        try {
            while (rs.next()) {
                is = new Ispitivac();
                is.setId(rs.getInt("id"));
                is.setIme(rs.getString("ime"));
                is.setOib(rs.getString("oib"));
                is.setOvlastenaTvrtka(rs.getString("ovlastenatvrtka"));
                is.setStrucnaSprema(rs.getString("strucnasprema"));
                is.setFunkcija(rs.getString("funkcijauorganizaciji"));
                is.setEmail(rs.getString("email"));
                is.setTelefon(rs.getString("telefon"));
                listaIspitivaca.add((Object)is);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FxDialogs.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(listaIspitivaca);
        comboBox.setCellFactory(cb -> new ListCell<Ispitivac>(){

            protected void updateItem(Ispitivac item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getIme());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    Ispitivac rm = (Ispitivac)t;
                    String str = rm.getIme();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Izaberite ispitiva\u010da");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getIme().toLowerCase().startsWith(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite ispitiva\u010da:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Ispitivac>(){

            public Ispitivac call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Ispitivac)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Ispitivac)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanDokument getDokumentiDijalog() {
        ObservableList listaDokumenti = FXCollections.observableArrayList();
        ResultSet rs = BazaDokumenti.getDokumentiAll(GlavniPanelController.getOdabranaTvrtka().getId());
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setOpisDokumenta(rs.getString("naziv"));
                listaDokumenti.add((Object)cd);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(listaDokumenti);
        comboBox.setCellFactory(cb -> new ListCell<ScanDokument>(){

            protected void updateItem(ScanDokument item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getOpisDokumenta());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    ScanDokument rm = (ScanDokument)t;
                    String str = rm.getOpisDokumenta();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setPromptText("Odaberite dokument");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getOpisDokumenta().toLowerCase().startsWith(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite dokument:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{comboBox});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, ScanDokument>(){

            public ScanDokument call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (ScanDokument)FxUtilTest.getComboBoxValue(comboBox);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (ScanDokument)result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZdrastvenaUstanova getZdrastvenaUstanovaDijalog() {
        ObservableList listaZdrastvenaUstanovas = FXCollections.observableArrayList();
        ResultSet rs = BazaZdrastvenaUstanova.dajUstanovu(GlavniPanelController.getOdabranaTvrtka());
        ZdrastvenaUstanova zu = null;
        try {
            while (rs.next()) {
                zu = new ZdrastvenaUstanova();
                zu.setId(rs.getInt("id"));
                zu.setNazivUstanove(rs.getString("nazivustanove"));
                zu.setOib(rs.getString("oib"));
                zu.setAdresa(rs.getString("adresa"));
                zu.setZupanija(rs.getString("zupanija"));
                zu.setPbr(rs.getString("pbr"));
                zu.setMjesto(rs.getString("mjesto"));
                zu.setOpcina(rs.getString("opcina"));
                zu.setDrzava(rs.getString("drzava"));
                zu.setNazivLijecnika(rs.getString("nazivlijecnika"));
                zu.setSifraLijecnika(rs.getString("sifralijecnika"));
                zu.setMedSestra(rs.getString("medsestra"));
                zu.setTelefon(rs.getString("telefon"));
                zu.setFax(rs.getString("fax"));
                zu.setMobitel(rs.getString("mobitel"));
                zu.setIban(rs.getString("iban"));
                zu.setNazivBanke(rs.getString("nazivbanke"));
                zu.setEmail(rs.getString("email"));
                zu.setDatumSklapanjaUgovora(DateUtil.getLocalDate(rs.getDate("datumsklapanjaugovora")));
                zu.setNapomena(rs.getString("napomena"));
                zu.setNazivDokumenta(rs.getString("dokumentugovor"));
                listaZdrastvenaUstanovas.add((Object)zu);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ComboBoxUtill.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(ComboBoxUtill.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox cboxCBoxZrastvenaUstanova = new ComboBox(listaZdrastvenaUstanovas);
        cboxCBoxZrastvenaUstanova.setCellFactory(cb -> new ListCell<ZdrastvenaUstanova>(){

            protected void updateItem(ZdrastvenaUstanova item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getNazivUstanove());
                }
            }
        });
        cboxCBoxZrastvenaUstanova.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    ZdrastvenaUstanova rm = (ZdrastvenaUstanova)t;
                    String str = rm.getNazivUstanove();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    cboxCBoxZrastvenaUstanova.setValue(null);
                    cboxCBoxZrastvenaUstanova.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        cboxCBoxZrastvenaUstanova.setPromptText("Odaberite zrastvenu ustanovu");
        FxUtilTest.autoCompleteComboBoxPlus(cboxCBoxZrastvenaUstanova, (typedText, itemToCompare) -> itemToCompare.getNazivUstanove().toLowerCase().contains(typedText.toLowerCase()));
        dialog.setHeaderText("Izaberite zrastvenu ustanovu:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        HBox vb = new HBox(new Node[]{cboxCBoxZrastvenaUstanova});
        vb.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)vb);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType(OK, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType(CANCEL, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, ZdrastvenaUstanova>(){

            public ZdrastvenaUstanova call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (ZdrastvenaUstanova)FxUtilTest.getComboBoxValue(cboxCBoxZrastvenaUstanova);
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (ZdrastvenaUstanova)result.get();
        }
        return null;
    }
}

