/*
 * Decompiled with CFR 0.152.
 */
package TamplatePaneli;

import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class ResizeListener
implements EventHandler<MouseEvent> {
    double dx;
    double dy;
    double deltaX;
    Scene scene;
    Stage stage;
    double deltaY;
    double border = 10.0;
    boolean moveH;
    boolean moveV;
    boolean resizeH = false;
    boolean resizeV = false;

    public ResizeListener(Scene scene, Stage stage) {
        this.scene = scene;
        this.stage = stage;
    }

    public void handle(MouseEvent t) {
        if (MouseEvent.MOUSE_MOVED.equals(t.getEventType())) {
            if (t.getX() < this.border && t.getY() < this.border) {
                this.scene.setCursor(Cursor.NW_RESIZE);
                this.resizeH = true;
                this.resizeV = true;
                this.moveH = true;
                this.moveV = true;
            } else if (t.getX() < this.border && t.getY() > this.scene.getHeight() - this.border) {
                this.scene.setCursor(Cursor.SW_RESIZE);
                this.resizeH = true;
                this.resizeV = true;
                this.moveH = true;
                this.moveV = false;
            } else if (t.getX() > this.scene.getWidth() - this.border && t.getY() < this.border) {
                this.scene.setCursor(Cursor.NE_RESIZE);
                this.resizeH = true;
                this.resizeV = true;
                this.moveH = false;
                this.moveV = true;
            } else if (t.getX() > this.scene.getWidth() - this.border && t.getY() > this.scene.getHeight() - this.border) {
                this.scene.setCursor(Cursor.SE_RESIZE);
                this.resizeH = true;
                this.resizeV = true;
                this.moveH = false;
                this.moveV = false;
            } else if (t.getX() < this.border || t.getX() > this.scene.getWidth() - this.border) {
                this.scene.setCursor(Cursor.E_RESIZE);
                this.resizeH = true;
                this.resizeV = false;
                this.moveH = t.getX() < this.border;
                this.moveV = false;
            } else if (t.getY() < this.border || t.getY() > this.scene.getHeight() - this.border) {
                this.scene.setCursor(Cursor.N_RESIZE);
                this.resizeH = false;
                this.resizeV = true;
                this.moveH = false;
                this.moveV = t.getY() < this.border;
            } else {
                this.scene.setCursor(Cursor.DEFAULT);
                this.resizeH = false;
                this.resizeV = false;
                this.moveH = false;
                this.moveV = false;
            }
        } else if (MouseEvent.MOUSE_PRESSED.equals(t.getEventType())) {
            this.dx = this.stage.getWidth() - t.getX();
            this.dy = this.stage.getHeight() - t.getY();
        } else if (MouseEvent.MOUSE_DRAGGED.equals(t.getEventType())) {
            double minSize;
            if (this.resizeH) {
                minSize = 0.0;
                if (this.stage.getWidth() <= minSize) {
                    if (this.moveH) {
                        this.deltaX = this.stage.getX() - t.getScreenX();
                        if (t.getX() < 0.0) {
                            this.stage.setWidth(this.deltaX + this.stage.getWidth());
                            this.stage.setX(t.getScreenX());
                        }
                    } else if (t.getX() + this.dx - this.stage.getWidth() > 0.0) {
                        this.stage.setWidth(t.getX() + this.dx);
                    }
                } else if (this.stage.getWidth() > minSize) {
                    if (this.moveH) {
                        this.deltaX = this.stage.getX() - t.getScreenX();
                        this.stage.setWidth(this.deltaX + this.stage.getWidth());
                        this.stage.setX(t.getScreenX());
                    } else {
                        this.stage.setWidth(t.getX() + this.dx);
                    }
                }
            }
            if (this.resizeV) {
                minSize = 0.0;
                if (this.stage.getHeight() <= minSize) {
                    if (this.moveV) {
                        this.deltaY = this.stage.getY() - t.getScreenY();
                        if (t.getY() < 0.0) {
                            this.stage.setHeight(this.deltaY + this.stage.getHeight());
                            this.stage.setY(t.getScreenY());
                        }
                    } else if (t.getY() + this.dy - this.stage.getHeight() > 0.0) {
                        this.stage.setHeight(t.getY() + this.dy);
                    }
                } else if (this.stage.getHeight() > minSize) {
                    if (this.moveV) {
                        this.deltaY = this.stage.getY() - t.getScreenY();
                        this.stage.setHeight(this.deltaY + this.stage.getHeight());
                        this.stage.setY(t.getScreenY());
                    } else {
                        this.stage.setHeight(t.getY() + this.dy);
                    }
                }
            }
        }
    }
}

